/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netxms.base.GeoLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class KMLParser {
    private static Logger logger = LoggerFactory.getLogger(KMLParser.class);

    public static Map<String, List<GeoLocation>> importPolygons(File file) {
        if (!file.exists()) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            logger.warn("Cannot load or parse KML file " + file.getPath(), e);
        }
        return doc != null ? KMLParser.importPolygons(doc) : null;
    }

    public static Map<String, List<GeoLocation>> importPolygons(String content) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));
            doc = builder.parse(in);
        }
        catch (Exception e) {
            logger.warn("Cannot load or parse KML from memory", e);
        }
        return doc != null ? KMLParser.importPolygons(doc) : null;
    }

    private static Map<String, List<GeoLocation>> importPolygons(Document doc) {
        HashMap<String, List<GeoLocation>> map = new HashMap<String, List<GeoLocation>>();
        NodeList nList = doc.getElementsByTagName("Placemark");
        for (int i = 0; i < nList.getLength(); ++i) {
            String[] lines;
            NodeList polygon;
            Node nNode = nList.item(i);
            if (nNode.getNodeType() != 1 || (polygon = ((Element)nNode).getElementsByTagName("Polygon")).getLength() < 1) continue;
            NodeList nameElement = ((Element)nNode).getElementsByTagName("name");
            String name = "Unknown";
            if (nameElement.getLength() >= 1) {
                name = ((Element)nameElement.item(0)).getTextContent().trim();
            }
            NodeList coordinatesElement = ((Element)polygon.item(0)).getElementsByTagName("coordinates");
            String coodinates = "";
            if (coordinatesElement.getLength() >= 1) {
                coodinates = ((Element)coordinatesElement.item(0)).getTextContent();
            }
            ArrayList<GeoLocation> border = new ArrayList<GeoLocation>();
            for (String line : lines = coodinates.split("\\r?\\n")) {
                String[] items = line.split(",");
                if (items.length < 2) continue;
                try {
                    border.add(new GeoLocation(Double.parseDouble(items[1]), Double.parseDouble(items[0])));
                }
                catch (NumberFormatException e) {
                    logger.debug("Error parsing polygon vertex in KML file");
                }
            }
            if (border.size() <= 0) continue;
            map.put(name, border);
        }
        return map;
    }
}

