/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.Set;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.ZoneMember;

public class Subnet
extends GenericObject
implements ZoneMember {
    private int zoneId;
    private InetAddressEx networkAddress;

    public Subnet(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.zoneId = msg.getFieldAsInt32(147L);
        this.networkAddress = msg.getFieldAsInetAddressEx(8L);
    }

    public InetAddressEx getNetworkAddress() {
        return this.networkAddress;
    }

    public InetAddress getSubnetAddress() {
        return this.networkAddress.getAddress();
    }

    public int getSubnetMask() {
        return this.networkAddress.getMask();
    }

    public boolean isPointToPoint() {
        return this.networkAddress.getHostBits() == 1;
    }

    @Override
    public String getObjectClassName() {
        return "Subnet";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    @Override
    public int getZoneId() {
        return this.zoneId;
    }

    @Override
    public String getZoneName() {
        Zone zone = this.session.findZone(this.zoneId);
        return zone != null ? zone.getObjectName() : Long.toString(this.zoneId);
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Subnet.addString(strings, this.networkAddress.getHostAddress());
        return strings;
    }
}

