/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.python.core.AbstractDict;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyCell;
import org.python.core.PyCode;
import org.python.core.PyDataDescr;
import org.python.core.PyFunction$__closure___descriptor;
import org.python.core.PyFunction$__code___descriptor;
import org.python.core.PyFunction$__dict___descriptor;
import org.python.core.PyFunction$__doc___descriptor;
import org.python.core.PyFunction$__module___descriptor;
import org.python.core.PyFunction$__name___descriptor;
import org.python.core.PyFunction$func_closure_descriptor;
import org.python.core.PyFunction$func_code_descriptor;
import org.python.core.PyFunction$func_dict_descriptor;
import org.python.core.PyFunction$func_globals_descriptor;
import org.python.core.PyFunction$func_name_descriptor;
import org.python.core.PyFunction$function___call___exposer;
import org.python.core.PyMethod;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="function", isBaseType=false, doc="function(code, globals[, name[, argdefs[, closure]]])\n\nCreate a function object from a code object and a dictionary.\nThe optional name string overrides the name from the code object.\nThe optional argdefs tuple specifies the default argument values.\nThe optional closure tuple supplies the bindings for free variables.")
public class PyFunction
extends PyObject
implements InvocationHandler,
Traverseproc {
    public static final PyType TYPE;
    public String __name__;
    public PyObject __doc__;
    public PyObject __globals__;
    public PyObject[] __defaults__;
    public PyCode __code__;
    public PyObject __dict__;
    public PyObject __closure__;
    public PyObject __module__;

    public PyFunction(PyObject globals, PyObject[] defaults, PyCode code2, PyObject doc, PyObject[] closure_cells) {
        super(TYPE);
        this.__globals__ = globals;
        this.__name__ = code2.co_name;
        this.__doc__ = doc != null ? doc : Py.None;
        this.__defaults__ = defaults != null && defaults.length == 0 ? null : defaults;
        this.__code__ = code2;
        this.__closure__ = closure_cells != null ? new PyTuple(closure_cells) : null;
        PyObject moduleName = globals.__finditem__("__name__");
        this.__module__ = moduleName != null ? moduleName : Py.None;
    }

    public PyFunction(PyObject globals, PyObject[] defaults, PyCode code2, PyObject doc) {
        this(globals, defaults, code2, doc, null);
    }

    public PyFunction(PyObject globals, PyObject[] defaults, PyCode code2) {
        this(globals, defaults, code2, null, null);
    }

    public PyFunction(PyObject globals, PyObject[] defaults, PyCode code2, PyObject[] closure_cells) {
        this(globals, defaults, code2, null, closure_cells);
    }

    @ExposedNew
    static final PyObject function___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nclosure;
        int nfree;
        ArgParser ap = new ArgParser("function", args, keywords, new String[]{"code", "globals", "name", "argdefs", "closure"}, 0);
        PyObject code2 = ap.getPyObject(0);
        PyObject globals = ap.getPyObject(1);
        PyObject name = ap.getPyObject(2, Py.None);
        PyObject defaults = ap.getPyObject(3, Py.None);
        PyObject closure = ap.getPyObject(4, Py.None);
        if (!(code2 instanceof PyBaseCode)) {
            throw Py.TypeError("function() argument 1 must be code, not " + code2.getType().fastGetName());
        }
        if (name != Py.None && !Py.isInstance(name, PyString.TYPE)) {
            throw Py.TypeError("arg 3 (name) must be None or string");
        }
        if (defaults != Py.None && !(defaults instanceof PyTuple)) {
            throw Py.TypeError("arg 4 (defaults) must be None or tuple");
        }
        PyBaseCode tcode = (PyBaseCode)code2;
        int n = nfree = tcode.co_freevars == null ? 0 : tcode.co_freevars.length;
        if (!(closure instanceof PyTuple)) {
            if (nfree > 0 && closure == Py.None) {
                throw Py.TypeError("arg 5 (closure) must be tuple");
            }
            if (closure != Py.None) {
                throw Py.TypeError("arg 5 (closure) must be None or tuple");
            }
        }
        int n2 = nclosure = closure == Py.None ? 0 : closure.__len__();
        if (nfree != nclosure) {
            throw Py.ValueError(String.format("%s requires closure of length %d, not %d", tcode.co_name, nfree, nclosure));
        }
        if (nclosure > 0) {
            for (PyObject o : ((PyTuple)closure).asIterable()) {
                if (o instanceof PyCell) continue;
                throw Py.TypeError(String.format("arg 5 (closure) expected cell, found %s", o.getType().fastGetName()));
            }
        }
        PyFunction function = new PyFunction(globals, defaults == Py.None ? null : ((PyTuple)defaults).getArray(), tcode, null, closure == Py.None ? null : ((PyTuple)closure).getArray());
        if (name != Py.None) {
            function.__name__ = name.toString();
        }
        return function;
    }

    public void setName(String func_name) {
        this.__name__ = func_name;
    }

    public void delName() {
        throw Py.TypeError("__name__ must be set to a string object");
    }

    @Deprecated
    public String getFuncName() {
        return this.__name__;
    }

    @Deprecated
    public void setFuncName(String func_name) {
        this.setName(func_name);
    }

    @Deprecated
    public void delFuncName() {
        this.delName();
    }

    @Deprecated
    public PyObject getFuncDoc() {
        return this.__doc__;
    }

    @Deprecated
    public void setFuncDoc(PyObject func_doc) {
        this.__doc__ = func_doc;
    }

    @Deprecated
    public void delFuncDoc() {
        this.delDoc();
    }

    public void delDoc() {
        this.__doc__ = Py.None;
    }

    public PyObject getDefaults() {
        if (this.__defaults__ == null) {
            return Py.None;
        }
        return new PyTuple(this.__defaults__);
    }

    public void setDefaults(PyObject func_defaults) {
        if (func_defaults != Py.None && !(func_defaults instanceof PyTuple)) {
            throw Py.TypeError("func_defaults must be set to a tuple object");
        }
        this.__defaults__ = func_defaults == Py.None ? null : ((PyTuple)func_defaults).getArray();
    }

    public void delDefaults() {
        this.__defaults__ = null;
    }

    @Deprecated
    public PyObject getFuncDefaults() {
        return this.getDefaults();
    }

    @Deprecated
    public void setFuncDefaults(PyObject func_defaults) {
        this.setDefaults(func_defaults);
    }

    @Deprecated
    public void delFuncDefaults() {
        this.delDefaults();
    }

    @Deprecated
    public PyCode getFuncCode() {
        return this.__code__;
    }

    @Deprecated
    public void setFuncCode(PyCode code2) {
        this.setCode(code2);
    }

    public void setCode(PyCode code2) {
        int nclosure;
        if (this.__code__ == null || !(code2 instanceof PyBaseCode)) {
            throw Py.TypeError("__code__ must be set to a code object");
        }
        PyBaseCode tcode = (PyBaseCode)code2;
        int nfree = tcode.co_freevars == null ? 0 : tcode.co_freevars.length;
        int n = nclosure = this.__closure__ != null ? this.__closure__.__len__() : 0;
        if (nclosure != nfree) {
            throw Py.ValueError(String.format("%s() requires a code object with %d free vars, not %d", this.__name__, nclosure, nfree));
        }
        this.__code__ = code2;
    }

    public void delModule() {
        this.__module__ = Py.None;
    }

    @Override
    public PyObject fastGetDict() {
        return this.__dict__;
    }

    @Override
    public PyObject getDict() {
        this.ensureDict();
        return this.__dict__;
    }

    @Override
    public void setDict(PyObject value) {
        if (!(value instanceof AbstractDict)) {
            throw Py.TypeError("setting function's dictionary to a non-dict");
        }
        this.__dict__ = value;
    }

    @Override
    public void delDict() {
        throw Py.TypeError("function's dictionary may not be deleted");
    }

    @Deprecated
    public PyObject getFuncDict() {
        return this.getDict();
    }

    @Deprecated
    public void setFuncDict(PyObject value) {
        this.setDict(value);
    }

    @Deprecated
    public void delFuncDict() {
        this.delDict();
    }

    public void setGlobals(PyObject value) {
        throw Py.TypeError("readonly attribute");
    }

    public void delGlobals() {
        throw Py.TypeError("readonly attribute");
    }

    @Deprecated
    public PyObject getFuncGlobals() {
        return this.__globals__;
    }

    @Deprecated
    public void setFuncGlobals(PyObject value) {
        this.setGlobals(value);
    }

    @Deprecated
    public void delFuncGlobals() {
        this.delGlobals();
    }

    public void setClosure(PyObject value) {
        throw Py.TypeError("readonly attribute");
    }

    public void delClosure() {
        throw Py.TypeError("readonly attribute");
    }

    @Deprecated
    public PyObject getFuncClosure() {
        return this.__closure__;
    }

    @Deprecated
    public void setFuncClosure(PyObject value) {
        this.setClosure(value);
    }

    @Deprecated
    public void delFuncClosure() {
        this.delClosure();
    }

    private void ensureDict() {
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.function___setattr__(name, value);
    }

    final void function___setattr__(String name, PyObject value) {
        this.ensureDict();
        super.__setattr__(name, value);
    }

    @Override
    public PyObject __get__(PyObject obj, PyObject type) {
        return this.function___get__(obj, type);
    }

    final PyObject function___get__(PyObject obj, PyObject type) {
        return new PyMethod(this, obj, type);
    }

    @Override
    public PyObject __call__() {
        return this.__call__(Py.getThreadState());
    }

    @Override
    public PyObject __call__(ThreadState state) {
        return this.__code__.call(state, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject arg) {
        return this.__call__(Py.getThreadState(), arg);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0) {
        return this.__code__.call(state, arg0, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject arg2) {
        return this.__call__(Py.getThreadState(), arg1, arg2);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1) {
        return this.__code__.call(state, arg0, arg1, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(Py.getThreadState(), arg1, arg2, arg3);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.__code__.call(state, arg0, arg1, arg2, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(Py.getThreadState(), arg0, arg1, arg2, arg3);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__code__.call(state, arg0, arg1, arg2, arg3, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject[] args) {
        return this.__call__(Py.getThreadState(), args);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject[] args) {
        return this.__call__(state, args, Py.NoKeywords);
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.__call__(Py.getThreadState(), args, keywords);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject[] args, String[] keywords) {
        return this.function___call__(state, args, keywords);
    }

    final PyObject function___call__(ThreadState state, PyObject[] args, String[] keywords) {
        return this.__code__.call(state, args, keywords, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject[] args, String[] keywords) {
        return this.__call__(Py.getThreadState(), arg1, args, keywords);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg1, PyObject[] args, String[] keywords) {
        return this.__code__.call(state, arg1, args, keywords, this.__globals__, this.__defaults__, this.__closure__);
    }

    @Override
    public String toString() {
        return String.format("<function %s at %s>", this.__name__, Py.idstr(this));
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c.isInstance(this) && c != InvocationHandler.class) {
            return c.cast(this);
        }
        if (c.isInterface()) {
            if (c.getDeclaredMethods().length == 1 && c.getInterfaces().length == 0) {
                return this.proxy(c);
            }
            String name = null;
            for (Method method : c.getMethods()) {
                if (method.getDeclaringClass() == Object.class) continue;
                if (name == null || name.equals(method.getName())) {
                    name = method.getName();
                    continue;
                }
                name = null;
                break;
            }
            if (name != null) {
                return this.proxy(c);
            }
        }
        return super.__tojava__(c);
    }

    private Object proxy(Class<?> c) {
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (args == null || args.length == 0) {
            return this.__call__().__tojava__(method.getReturnType());
        }
        return this.__call__(Py.javas2pys(args)).__tojava__(method.getReturnType());
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    private Object readResolve() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = visit.visit(this.__globals__, arg);
        if (retVal != 0) {
            return retVal;
        }
        if (this.__code__ != null && (retVal = visit.visit(this.__code__, arg)) != 0) {
            return retVal;
        }
        retVal = visit.visit(this.__module__, arg);
        if (retVal != 0) {
            return retVal;
        }
        if (this.__defaults__ != null) {
            for (PyObject ob : this.__defaults__) {
                if (ob == null || (retVal = visit.visit(ob, arg)) == 0) continue;
                return retVal;
            }
        }
        if ((retVal = visit.visit(this.__doc__, arg)) != 0) {
            return retVal;
        }
        if (this.__dict__ != null && (retVal = visit.visit(this.__dict__, arg)) != 0) {
            return retVal;
        }
        return this.__closure__ != null ? visit.visit(this.__closure__, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        if (ob == null) {
            return false;
        }
        if (this.__defaults__ != null) {
            for (PyObject obj : this.__defaults__) {
                if (obj != ob) continue;
                return true;
            }
        }
        return ob == this.__doc__ || ob == this.__globals__ || ob == this.__code__ || ob == this.__dict__ || ob == this.__closure__ || ob == this.__module__;
    }

    static {
        PyType.addBuilder(PyFunction.class, new PyFunction$PyExposer());
        TYPE = PyType.fromClass(PyFunction.class);
    }

    public class PyFunction$function___setattr___exposer
    extends PyBuiltinMethodNarrow {
        public PyFunction$function___setattr___exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "x.__setattr__('name', value) <==> x.name = value";
        }

        public PyFunction$function___setattr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__setattr__('name', value) <==> x.name = value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFunction$function___setattr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyFunction)this.self).function___setattr__(pyObject.asString(), pyObject2);
            return Py.None;
        }
    }

    public class PyFunction$function___get___exposer
    extends PyBuiltinMethodNarrow {
        public PyFunction$function___get___exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyFunction$function___get___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFunction$function___get___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyFunction)this.self).function___get__(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFunction)this.self).function___get__(pyObject, null);
        }
    }

    public class PyFunction$__defaults___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyFunction$__defaults___descriptor() {
            super("__defaults__", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFunction)pyObject).getDefaults();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyFunction)pyObject).setDefaults((PyObject)object);
        }

        public boolean implementsDescrSet() {
            return true;
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyFunction)pyObject).delDefaults();
        }

        public boolean implementsDescrDelete() {
            return true;
        }
    }

    public class PyFunction$__globals___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyFunction$__globals___descriptor() {
            super("__globals__", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFunction)pyObject).__globals__;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyFunction)pyObject).setGlobals((PyObject)object);
        }

        public boolean implementsDescrSet() {
            return true;
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyFunction)pyObject).delGlobals();
        }

        public boolean implementsDescrDelete() {
            return true;
        }
    }

    public class PyFunction$func_defaults_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyFunction$func_defaults_descriptor() {
            super("func_defaults", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFunction)pyObject).getFuncDefaults();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyFunction)pyObject).setFuncDefaults((PyObject)object);
        }

        public boolean implementsDescrSet() {
            return true;
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyFunction)pyObject).delFuncDefaults();
        }

        public boolean implementsDescrDelete() {
            return true;
        }
    }

    public class PyFunction$func_doc_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyFunction$func_doc_descriptor() {
            super("func_doc", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFunction)pyObject).getFuncDoc();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyFunction)pyObject).setFuncDoc((PyObject)object);
        }

        public boolean implementsDescrSet() {
            return true;
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyFunction)pyObject).delFuncDoc();
        }

        public boolean implementsDescrDelete() {
            return true;
        }
    }

    public class PyFunction$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyFunction.function___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyFunction$PyExposer
    extends BaseTypeBuilder {
        public PyFunction$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyFunction$function___setattr___exposer("__setattr__"), new PyFunction$function___get___exposer("__get__"), new PyFunction$function___call___exposer("__call__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyFunction$func_dict_descriptor(), new PyFunction$func_closure_descriptor(), new PyFunction$__defaults___descriptor(), new PyFunction$__dict___descriptor(), new PyFunction$__module___descriptor(), new PyFunction$__globals___descriptor(), new PyFunction$func_globals_descriptor(), new PyFunction$func_defaults_descriptor(), new PyFunction$__name___descriptor(), new PyFunction$__code___descriptor(), new PyFunction$__closure___descriptor(), new PyFunction$func_doc_descriptor(), new PyFunction$__doc___descriptor(), new PyFunction$func_code_descriptor(), new PyFunction$func_name_descriptor()};
            super("function", PyFunction.class, Object.class, false, "function(code, globals[, name[, argdefs[, closure]]])\n\nCreate a function object from a code object and a dictionary.\nThe optional name string overrides the name from the code object.\nThe optional argdefs tuple specifies the default argument values.\nThe optional closure tuple supplies the bindings for free variables.", pyBuiltinMethodArray, pyDataDescrArray, new PyFunction$exposed___new__());
        }
    }
}

