/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.permutations$exposed___new__;
import org.python.modules.itertools.permutations$permutations___init___exposer;

@ExposedType(name="itertools.permutations", base=PyObject.class, doc="permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)")
public class permutations
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String permutations_doc = "permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)";

    public permutations() {
    }

    public permutations(PyType subType) {
        super(subType);
    }

    public permutations(PyObject iterable, int r) {
        this.permutations___init__(iterable, r);
    }

    @ExposedNew
    final void permutations___init__(PyObject[] args, String[] kwds) {
        int perm_length;
        if (args.length > 2) {
            throw Py.TypeError("permutations() takes at most 2 arguments (3 given)");
        }
        ArgParser ap = new ArgParser("permutations", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        PyObject r = ap.getPyObject(1, Py.None);
        if (r == Py.None) {
            perm_length = iterable.__len__();
        } else {
            perm_length = r.asInt();
            if (perm_length < 0) {
                throw Py.ValueError("r must be non-negative");
            }
        }
        this.permutations___init__(iterable, perm_length);
    }

    private void permutations___init__(PyObject iterable, final int r) {
        final PyTuple pool = PyTuple.fromIterable(iterable);
        final int n = pool.__len__();
        final int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        final int[] cycles = new int[r];
        for (int i = 0; i < r; ++i) {
            cycles[i] = n - i;
        }
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                if (r > n) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(pool, indices, r);
                }
                for (int i = r - 1; i >= 0; --i) {
                    int first;
                    int n2 = i;
                    cycles[n2] = cycles[n2] - 1;
                    if (cycles[i] == 0) {
                        first = indices[i];
                        for (int j = i; j < n - 1; ++j) {
                            indices[j] = indices[j + 1];
                        }
                    } else {
                        int j = cycles[i];
                        int index = indices[i];
                        indices[i] = indices[n - j];
                        indices[n - j] = index;
                        return itertools.makeIndexedTuple(pool, indices, r);
                    }
                    indices[n - 1] = first;
                    cycles[i] = n - i;
                }
                return null;
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(permutations.class, new permutations$PyExposer());
        TYPE = PyType.fromClass(permutations.class);
    }

    public class permutations$next_exposer
    extends PyBuiltinMethodNarrow {
        public permutations$next_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public permutations$next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new permutations$next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((permutations)this.self).next();
        }
    }

    public class permutations$PyExposer
    extends BaseTypeBuilder {
        public permutations$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new permutations$permutations___init___exposer("__init__"), new permutations$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.permutations", permutations.class, PyObject.class, true, "permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)", pyBuiltinMethodArray, pyDataDescrArray, new permutations$exposed___new__());
        }
    }
}

