/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;

public class GeoArea {
    protected int id;
    protected String name;
    protected String comments;
    protected List<GeoLocation> border;

    public GeoArea(int id, String name, String comments, List<GeoLocation> border) {
        this.id = id;
        this.name = name;
        this.comments = comments;
        this.border = new ArrayList<GeoLocation>(border);
    }

    public GeoArea(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt32(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        this.comments = msg.getFieldAsString(baseId + 2L);
        int count = msg.getFieldAsInt32(baseId + 3L);
        this.border = new ArrayList<GeoLocation>(count);
        if (count > 0) {
            long fieldId = baseId + 10L;
            for (int i = 0; i < count; ++i) {
                double lat = msg.getFieldAsDouble(fieldId++);
                double lon = msg.getFieldAsDouble(fieldId++);
                this.border.add(new GeoLocation(lat, lon));
            }
        }
    }

    public GeoArea(GeoArea src) {
        this.id = src.id;
        this.name = src.name;
        this.comments = src.comments;
        this.border = new ArrayList<GeoLocation>(src.border);
    }

    void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(723L, this.id);
        msg.setField(20L, this.name);
        msg.setField(82L, this.comments);
        msg.setFieldInt16(361L, this.border.size());
        long fieldId = 0x10000000L;
        for (GeoLocation l : this.border) {
            msg.setField(fieldId++, l.getLatitude());
            msg.setField(fieldId++, l.getLongitude());
        }
    }

    public GeoLocation[] getBoundingBox() {
        double west;
        double south;
        if (this.border.isEmpty()) {
            return new GeoLocation[]{new GeoLocation(0.0, 0.0), new GeoLocation(0.0, 0.0)};
        }
        double north = south = this.border.get(0).getLatitude();
        double east = west = this.border.get(0).getLongitude();
        for (int i = 1; i < this.border.size(); ++i) {
            GeoLocation l = this.border.get(i);
            if (l.getLatitude() < south) {
                south = l.getLatitude();
            } else if (l.getLatitude() > north) {
                north = l.getLatitude();
            }
            if (l.getLongitude() < west) {
                west = l.getLongitude();
                continue;
            }
            if (!(l.getLongitude() > east)) continue;
            east = l.getLongitude();
        }
        return new GeoLocation[]{new GeoLocation(north, west), new GeoLocation(south, east)};
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name != null ? this.name : "[" + Integer.toString(this.id) + "]";
    }

    public String getComments() {
        return this.comments != null ? this.comments : "";
    }

    public List<GeoLocation> getBorder() {
        return this.border;
    }
}

