/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObjectStatus {
    NORMAL(0),
    WARNING(1),
    MINOR(2),
    MAJOR(3),
    CRITICAL(4),
    UNKNOWN(5),
    UNMANAGED(6),
    DISABLED(7),
    TESTING(8);

    private static Logger logger;
    private static Map<Integer, ObjectStatus> lookupTable;
    private int value;

    private ObjectStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ObjectStatus getByValue(int value) {
        ObjectStatus element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(ObjectStatus.class);
        lookupTable = new HashMap<Integer, ObjectStatus>();
        for (ObjectStatus element : ObjectStatus.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

