/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.annotations.Internal;
import org.netxms.client.datacollection.GraphSettings;

public class GraphFolder {
    @Internal
    private GraphFolder parent;
    private String name;
    private String displayName;
    private Map<String, GraphFolder> subfolders;
    private Map<Long, GraphSettings> graphs;

    public GraphFolder(String name) {
        this.name = name;
        this.displayName = name.replace("&", "");
        this.parent = null;
        this.subfolders = new HashMap<String, GraphFolder>();
        this.graphs = new HashMap<Long, GraphSettings>();
    }

    public void clear() {
        this.subfolders.clear();
        this.graphs.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GraphFolder getParent() {
        return this.parent;
    }

    public void setParent(GraphFolder parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Object[] getChildren() {
        Object[] objects = new Object[this.subfolders.size() + this.graphs.size()];
        int index = 0;
        for (GraphFolder f : this.subfolders.values()) {
            objects[index++] = f;
        }
        for (GraphSettings s : this.graphs.values()) {
            objects[index++] = s;
        }
        return objects;
    }

    public boolean hasChildren() {
        return !this.subfolders.isEmpty() || !this.graphs.isEmpty();
    }

    public void addGraph(GraphSettings g) {
        g.setParent(this);
        this.graphs.put(g.getId(), g);
    }

    public void addFolder(GraphFolder f) {
        f.setParent(this);
        this.subfolders.put(f.getDisplayName(), f);
    }

    private void updateGraphInternal(GraphSettings graph, String[] path, int level) {
        if (level == path.length - 1) {
            this.addGraph(graph);
        } else {
            GraphFolder f = this.subfolders.get(path[level].replace("&", ""));
            if (f == null) {
                f = new GraphFolder(path[level]);
                this.addFolder(f);
            }
            f.updateGraphInternal(graph, path, level + 1);
        }
    }

    public void updateGraph(GraphSettings graph) {
        if (this.parent != null) {
            return;
        }
        this.removeGraph(graph.getId());
        String[] path = graph.getName().split("->");
        this.updateGraphInternal(graph, path, 0);
    }

    public boolean removeGraph(long id) {
        if (this.graphs.remove(id) != null) {
            return true;
        }
        if (!this.subfolders.isEmpty()) {
            for (GraphFolder f : this.subfolders.values()) {
                if (!f.removeGraph(id)) continue;
                if (!f.hasChildren()) {
                    this.subfolders.remove(f.getDisplayName());
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "GraphFolder [name=" + this.name + ", subfolders=" + this.subfolders + ", graphs=" + this.graphs + "]";
    }
}

