/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AgentFileInfo;

public class AgentFile {
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int SYMBOLYC_LINK = 4;
    public static final int PLACEHOLDER = 65536;
    private String name;
    private long size;
    private Date modificationTime;
    private String extension;
    private int type = 0;
    private String owner;
    private String group;
    private String accessRights;
    private List<AgentFile> children;
    private AgentFile parent;
    private long nodeId;
    private AgentFileInfo info;

    public AgentFile(NXCPMessage msg, long baseId, AgentFile parent, long nodeId) {
        this.name = msg.getFieldAsString(baseId);
        this.size = msg.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg.getFieldAsDate(baseId + 2L);
        this.type = (int)msg.getFieldAsInt64(baseId + 3L);
        this.owner = msg.getFieldAsString(baseId + 5L);
        this.group = msg.getFieldAsString(baseId + 6L);
        this.accessRights = msg.getFieldAsString(baseId + 7L);
        this.parent = parent;
        this.nodeId = nodeId;
        this.setExtension();
    }

    public AgentFile(String name, int fileType, AgentFile parent, long nodeId) {
        this.name = name;
        this.type = fileType;
        this.parent = parent;
        this.nodeId = nodeId;
        this.modificationTime = new Date();
        this.setExtension();
    }

    public AgentFile(AgentFile src) {
        this.name = src.name;
        this.size = src.size;
        this.modificationTime = src.modificationTime;
        this.type = src.type;
        this.owner = src.owner;
        this.group = src.group;
        this.accessRights = src.accessRights;
        this.nodeId = src.nodeId;
        this.setExtension();
    }

    private void setExtension() {
        if (this.isDirectory() || this.name.startsWith(".")) {
            this.extension = " ";
            return;
        }
        String[] parts = this.name.split("\\.");
        this.extension = parts.length > 1 ? parts[parts.length - 1] : " ";
    }

    public boolean isDirectory() {
        return (this.type & 2) > 0;
    }

    public boolean isPlaceholder() {
        return (this.type & 0x10000) > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtension();
    }

    public long getSize() {
        return this.size;
    }

    public Date getModifyicationTime() {
        return this.modificationTime;
    }

    public String getExtension() {
        return this.extension;
    }

    public List<AgentFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<AgentFile> children) {
        this.children = children;
    }

    public void removeChield(AgentFile chield) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(chield.getName())) continue;
            this.children.remove(i);
        }
    }

    public void addChield(AgentFile chield) {
        if (this.children == null) {
            return;
        }
        boolean childReplaced = false;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(chield.getName())) continue;
            if (chield.getType() != 2) {
                this.children.set(i, chield);
            }
            childReplaced = true;
            break;
        }
        if (!childReplaced) {
            this.children.add(chield);
        }
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFullName() + "/" + this.name;
    }

    public String getFilePath() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFilePath() + (this.parent.getFilePath().endsWith("/") || this.parent.getFilePath().endsWith("\\") ? "" : (this.parent.getFilePath().contains("\\") || this.parent.getFilePath().contains(":") ? "\\" : "/")) + this.name;
    }

    public AgentFile getParent() {
        return this.parent;
    }

    public void setParent(AgentFile parent) {
        this.parent = parent;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getAccessRights() {
        return this.accessRights;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public void setFileInfo(AgentFileInfo info) {
        this.info = info;
    }

    public AgentFileInfo getFileInfo() {
        return this.info;
    }
}

