/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.jira;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.radensolutions.jira.SettingsManager;
import java.util.ArrayList;
import java.util.List;

public class SettingsManagerImpl
implements SettingsManager {
    private static final String NAMESPACE = "netxms-";
    public static final String KEY_PASSWORD = "netxms-password";
    public static final String KEY_LOGIN = "netxms-login";
    public static final String KEY_SERVERS = "netxms-servers";
    public static final String KEY_ENABLED = "netxms-enabled";
    public static final String KEY_PROJECT = "netxms-project";
    public static final String KEY_JIRA_ACCOUNT = "netxms-jira-account";
    private final PluginSettingsFactory pluginSettingsFactory;

    public SettingsManagerImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public List<String> getServers() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object o = globalSettings.get(KEY_SERVERS);
        return o == null ? new ArrayList(0) : (List)o;
    }

    @Override
    public void setServers(List<String> servers) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_SERVERS, servers);
    }

    @Override
    public String getLogin() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)globalSettings.get(KEY_LOGIN);
    }

    @Override
    public void setLogin(String login) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_LOGIN, (Object)login);
    }

    @Override
    public String getPassword() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)globalSettings.get(KEY_PASSWORD);
    }

    @Override
    public void setPassword(String password) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_PASSWORD, (Object)password);
    }

    @Override
    public boolean isEnabled() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        String enabled = (String)globalSettings.get(KEY_ENABLED);
        return enabled != null && enabled.equals("YES");
    }

    @Override
    public void setEnabled(boolean enabled) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_ENABLED, (Object)(enabled ? "YES" : "NO"));
    }

    @Override
    public String getProjectKey() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)globalSettings.get(KEY_PROJECT);
    }

    @Override
    public void setProjectKey(String projectKey) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_PROJECT, (Object)projectKey);
    }

    @Override
    public String getJiraAccount() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)globalSettings.get(KEY_JIRA_ACCOUNT);
    }

    @Override
    public void setJiraAccount(String jiraAccount) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(KEY_JIRA_ACCOUNT, (Object)jiraAccount);
    }
}

