/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HistoricalDataType {
    PROCESSED(0),
    RAW(1),
    BOTH(2);

    private static Logger logger;
    private static Map<Integer, HistoricalDataType> lookupTable;
    private int value;

    private HistoricalDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HistoricalDataType getByValue(int value) {
        HistoricalDataType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return PROCESSED;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(HistoricalDataType.class);
        lookupTable = new HashMap<Integer, HistoricalDataType>();
        for (HistoricalDataType element : HistoricalDataType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

