/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import com.jcraft.jzlib.InflaterInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.client.NXCException;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;

public class MibTree {
    private static final byte[] MIB_FILE_MAGIC_NUMBER = new byte[]{78, 88, 77, 73, 66, 32};
    protected static final int SMT_COMPRESS_DATA = 1;
    protected static final int SMT_SKIP_DESCRIPTIONS = 2;
    private MibObject root;

    public MibTree() {
        this.root = new MibObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MibTree(File file) throws IOException, NXCException {
        block11: {
            try (NXCPDataInputStream in = new NXCPDataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                byte[] magic = new byte[6];
                int bytes = in.read(magic);
                if (bytes != 6 || !Arrays.equals(magic, MIB_FILE_MAGIC_NUMBER)) {
                    throw new NXCException(1001);
                }
                int headerSize = in.readUnsignedByte();
                in.skipBytes(1);
                int flags = in.readUnsignedShort();
                if ((flags & 1) != 0) {
                    in.close();
                    in = null;
                    BufferedInputStream bufferedInput = new BufferedInputStream(new FileInputStream(file));
                    if (bufferedInput.skip(headerSize) != (long)headerSize) {
                        try {
                            bufferedInput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new NXCException(1002);
                    }
                    in = new NXCPDataInputStream(new InflaterInputStream(bufferedInput));
                } else {
                    in.skipBytes(headerSize - 10);
                }
                int tag = in.readUnsignedByte();
                if (tag == 1) {
                    this.root = new MibObject(in, null);
                    break block11;
                }
                throw new NXCException(1002);
            }
        }
    }

    public MibObject getRootObject() {
        return this.root;
    }

    public MibObject findObject(SnmpObjectId oid, boolean exactMatch) {
        MibObject result = this.root.findChildObject(oid);
        if (result != null && exactMatch && !oid.equals(result.getObjectId())) {
            return null;
        }
        return result;
    }
}

