/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.dao;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.radensolutions.reporting.service.ServerSettings;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"com.radensolutions.reporting"})
@EnableTransactionManagement
public class DaoContextConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DaoContextConfig.class);
    @Autowired
    private ServerSettings settings;

    public void afterPropertiesSet() throws Exception {
        log.debug("DaoContextConfig initialized.");
    }

    @Bean
    @Qualifier(value="systemDataSource")
    public DataSource dataSource() throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        ServerSettings.DataSourceConfig dataSourceConfig = this.settings.getDataSourceConfig("system");
        dataSource.setDriverClass(dataSourceConfig.getDriver());
        dataSource.setJdbcUrl(dataSourceConfig.getUrl());
        dataSource.setUser(dataSourceConfig.getUsername());
        dataSource.setPassword(dataSourceConfig.getPassword());
        dataSource.setTestConnectionOnCheckout(true);
        dataSource.setCheckoutTimeout(3000);
        dataSource.setIdleConnectionTestPeriod(300);
        return dataSource;
    }

    private Properties hibernateProperties() {
        Properties properties = new Properties();
        ServerSettings.DataSourceConfig dataSourceConfig = this.settings.getDataSourceConfig("system");
        properties.setProperty("hibernate.dialect", dataSourceConfig.getDialect());
        properties.setProperty("hibernate.show_sql", "true");
        return properties;
    }

    @Autowired
    @Bean
    public SessionFactory sessionFactory(DataSource dataSource) {
        LocalSessionFactoryBuilder sessionBuilder = new LocalSessionFactoryBuilder(dataSource);
        sessionBuilder.addProperties(this.hibernateProperties());
        sessionBuilder.scanPackages(new String[]{"com.radensolutions.reporting.model"});
        return sessionBuilder.buildSessionFactory();
    }

    @Autowired
    @Bean
    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory) {
        return new HibernateTransactionManager(sessionFactory);
    }
}

