/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.base.annotations.Internal;
import org.netxms.client.AccessListElement;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.datacollection.ChartConfig;
import org.netxms.client.datacollection.GraphFolder;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objecttools.ObjectAction;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSettings
extends ChartConfig
implements ObjectAction {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int TIME_FRAME_FIXED = 0;
    public static final int TIME_FRAME_BACK_FROM_NOW = 1;
    public static final int TIME_FRAME_CURRENT = 2;
    public static final int TIME_UNIT_MINUTE = 0;
    public static final int TIME_UNIT_HOUR = 1;
    public static final int TIME_UNIT_DAY = 2;
    public static final int GF_AUTO_UPDATE = 1;
    public static final int GF_AUTO_SCALE = 256;
    public static final int GF_SHOW_GRID = 512;
    public static final int GF_SHOW_LEGEND = 1024;
    public static final int GF_SHOW_RULER = 2048;
    public static final int GF_SHOW_HOST_NAMES = 4096;
    public static final int GF_LOG_SCALE = 8192;
    public static final int GF_SHOW_TOOLTIPS = 16384;
    public static final int GF_ENABLE_ZOOM = 32768;
    public static final int GF_DISABLE_MULTIPLIERS = 65536;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int GRAPH_FLAG_TEMPLATE = 1;
    private static Logger logger = LoggerFactory.getLogger(GraphSettings.class);
    @Internal
    private GraphFolder parent;
    private long id;
    private long ownerId;
    private int flags;
    private String name;
    private String shortName;
    private String displayName;
    private List<AccessListElement> accessList;
    private ObjectMenuFilter filter;

    public GraphSettings() {
        this.id = 0L;
        this.ownerId = 0L;
        this.flags = 0;
        this.name = "noname";
        this.shortName = "noname";
        this.displayName = "noname";
        this.accessList = new ArrayList<AccessListElement>(0);
        this.filter = new ObjectMenuFilter();
        this.parent = null;
    }

    public GraphSettings(long id, long ownerId, int flags, Collection<AccessListElement> accessList) {
        this.id = id;
        this.ownerId = ownerId;
        this.name = "noname";
        this.shortName = "noname";
        this.displayName = "noname";
        this.flags = flags;
        this.accessList = new ArrayList<AccessListElement>(accessList.size());
        this.accessList.addAll(accessList);
        this.filter = new ObjectMenuFilter();
        this.parent = null;
    }

    public GraphSettings(GraphSettings src, String name) {
        this.id = src.id;
        this.ownerId = src.ownerId;
        this.name = src.name;
        this.shortName = src.shortName;
        this.displayName = src.displayName;
        this.flags = src.flags & 0xFFFFFFFE;
        this.accessList = new ArrayList<AccessListElement>(src.accessList.size());
        this.accessList.addAll(src.accessList);
        this.filter = src.filter;
        this.setConfig(src);
        this.setTitle(name);
        this.parent = null;
    }

    public GraphSettings(GraphSettings src) {
        this.id = src.id;
        this.ownerId = src.ownerId;
        this.name = src.name;
        this.shortName = src.shortName;
        this.displayName = src.displayName;
        this.flags = src.flags & 0xFFFFFFFE;
        this.accessList = new ArrayList<AccessListElement>(src.accessList.size());
        this.accessList.addAll(src.accessList);
        this.filter = src.filter;
        this.setConfig(src);
        this.setTitle(src.getTitle());
        this.parent = null;
    }

    public static GraphSettings createFromXml(String xml) throws Exception {
        Persister serializer = new Persister((Strategy)new AnnotationStrategy());
        return (GraphSettings)serializer.read(GraphSettings.class, xml);
    }

    public static GraphSettings createGraphSettings(NXCPMessage msg, long baseId) {
        String[] parts;
        GraphSettings gs;
        try {
            gs = GraphSettings.createFromXml(msg.getFieldAsString(baseId + 4L));
        }
        catch (Exception e) {
            gs = new GraphSettings();
            logger.debug("Cannot create GraphSettings object from XML", (Throwable)e);
        }
        gs.id = msg.getFieldAsInt64(baseId);
        gs.ownerId = msg.getFieldAsInt64(baseId + 1L);
        gs.flags = (int)msg.getFieldAsInt64(baseId + 2L);
        gs.name = msg.getFieldAsString(baseId + 3L);
        String filterXml = msg.getFieldAsString(baseId + 5L);
        if (filterXml != null && !filterXml.isEmpty()) {
            try {
                gs.filter = ObjectMenuFilter.createFromXml(filterXml);
            }
            catch (Exception e) {
                logger.debug("Cannot create ObjectMenuFilter object from XML", (Throwable)e);
                gs.filter = new ObjectMenuFilter();
            }
        } else {
            gs.filter = new ObjectMenuFilter();
        }
        gs.shortName = (parts = gs.name.split("->")).length > 1 ? parts[parts.length - 1] : gs.name;
        gs.displayName = gs.shortName.replace("&", "");
        int count = msg.getFieldAsInt32(baseId + 6L);
        long[] users = msg.getFieldAsUInt32Array(baseId + 7L);
        long[] rights = msg.getFieldAsUInt32Array(baseId + 8L);
        gs.accessList = new ArrayList<AccessListElement>(count);
        for (int i = 0; i < count; ++i) {
            gs.accessList.add(new AccessListElement(users[i], (int)rights[i]));
        }
        return gs;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(274L, (int)this.id);
        msg.setField(20L, this.name);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(232L, this.filter.createXml());
        try {
            msg.setField(272L, this.createXml());
        }
        catch (Exception e) {
            logger.debug("Cannot convert GraphSettings object to XML", (Throwable)e);
            msg.setField(272L, "");
        }
        msg.setFieldInt32(32L, this.accessList.size());
        long varId = 0x20000000L;
        for (AccessListElement el : this.accessList) {
            msg.setFieldInt32(varId++, (int)el.getUserId());
            msg.setFieldInt32(varId++, el.getAccessRights());
        }
    }

    public long getId() {
        return this.id;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public List<AccessListElement> getAccessList() {
        return this.accessList;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setName(String name) {
        this.name = name;
        String[] parts = name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : name;
        this.displayName = this.shortName.replace("&", "");
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isTemplate() {
        return (this.flags & 1) > 0;
    }

    public GraphFolder getParent() {
        return this.parent;
    }

    public void setParent(GraphFolder parent) {
        this.parent = parent;
    }

    @Override
    public boolean isApplicableForNode(AbstractNode node) {
        return this.filter.isApplicableForNode(node);
    }

    @Override
    public ObjectMenuFilter getMenuFilter() {
        return this.filter;
    }

    @Override
    public void setMenuFilter(ObjectMenuFilter filter) {
        this.filter = filter;
    }

    @Override
    public int getToolType() {
        return 0;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return "GraphSettings [id=" + this.id + ", ownerId=" + this.ownerId + ", flags=" + this.flags + ", name=" + this.name + ", shortName=" + this.shortName + ", accessList=" + this.accessList + ", filter=" + this.filter + "]";
    }
}

