/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.ReportClassLoader;
import com.radensolutions.reporting.ThreadLocalReportInfo;
import com.radensolutions.reporting.custom.NXCLDataSource;
import com.radensolutions.reporting.service.ServerSettings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXCLQueryExecutor
implements JRQueryExecuter {
    private static final Logger log = LoggerFactory.getLogger(NXCLQueryExecutor.class);
    private ServerSettings settings;
    private JRDataset dataset;
    private Map<String, ? extends JRValueParameter> parametersMap;

    protected NXCLQueryExecutor(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this.dataset = dataset;
        this.parametersMap = parametersMap;
    }

    public JRDataSource createDatasource() throws JRException {
        String reportLocation = ThreadLocalReportInfo.getReportLocation();
        try {
            URL[] urls = new URL[]{new URL("file:" + reportLocation)};
            ReportClassLoader classLoader = new ReportClassLoader(urls, this.getClass().getClassLoader());
            Class<?> aClass = classLoader.loadClass("report.DataSource");
            Constructor<?> constructor = aClass.getConstructor(JRDataset.class, Map.class);
            NXCLDataSource dataSource = (NXCLDataSource)constructor.newInstance(this.dataset, this.parametersMap);
            JRQueryChunk chunk = this.dataset.getQuery().getChunks()[0];
            dataSource.setQuery(chunk.getText().trim());
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        catch (ClassNotFoundException urls) {
        }
        catch (MalformedURLException e) {
            log.error("Can't load report data source", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error("Can't load report data source", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Can't load report data source", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("Can't load report data source", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("Can't load report data source", (Throwable)e);
        }
        return null;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        System.out.println("cancelQuery");
        return false;
    }

    public void setSettings(ServerSettings settings) {
        this.settings = settings;
    }
}

