/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.model.Notification;
import com.radensolutions.reporting.service.NotificationService;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationServiceImpl
implements NotificationService {
    @Autowired
    private SessionFactory session;

    @Override
    @Transactional
    public void create(Notification notify) {
        this.session.getCurrentSession().save((Object)notify);
    }

    @Override
    @Transactional
    public List<Notification> load(UUID jobId) {
        Query query = this.session.getCurrentSession().createQuery("from Notification where jobId = :jobId").setParameter("jobId", (Object)jobId);
        return Collections.checkedList(query.list(), Notification.class);
    }

    @Override
    @Transactional
    public void delete(UUID jobId) {
        Query query = this.session.getCurrentSession().createQuery("from Notification where jobId = :jobId").setParameter("jobId", (Object)jobId);
        List<Notification> list = Collections.checkedList(query.list(), Notification.class);
        for (Notification notify : list) {
            this.session.getCurrentSession().delete((Object)notify);
        }
    }
}

