/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import name.pachler.nio.file.impl.NativeLibLoader;

public abstract class Unix {
    static final int EINTR;
    static final int EINVAL;
    static final int EBADF;
    static final int ENOENT;
    static final int O_RDONLY;
    static final int O_WRONLY;
    static final int O_RDWR;
    static final int O_APPEND;
    static final int O_CREAT;
    static final int O_EXCL;
    static final int O_NOCTTY;
    static final int O_NONBLOCK;
    static final int O_SYNC;
    static final int O_TRUNC;
    static final int S_ISUID;
    static final int S_ISGID;
    static final int S_IRWXU;
    static final int S_IRUSR;
    static final int S_IWUSR;
    static final int S_IXUSR;
    static final int S_IRWXG;
    static final int S_IRGRP;
    static final int S_IWGRP;
    static final int S_IXGRP;
    static final int S_IRWXO;
    static final int S_IROTH;
    static final int S_IWOTH;
    static final int S_IXOTH;

    protected static native int getIntDefine(String var0);

    static native int open(String var0, int var1, int var2);

    static native int close(int var0);

    static native int select(int[] var0, int[] var1, int[] var2, long var3);

    static native int ioctl_FIONREAD(int var0);

    static native int read(int var0, byte[] var1, int var2);

    static native int write(int var0, byte[] var1, int var2);

    static native int pipe(int[] var0);

    static native int errno();

    static native String strerror(int var0);

    static native boolean S_ISREG(int var0);

    static native boolean S_ISDIR(int var0);

    static native boolean S_ISCHR(int var0);

    static native boolean S_ISBLK(int var0);

    static native boolean S_ISFIFO(int var0);

    static native boolean S_ISLNK(int var0);

    static native boolean S_ISSOCK(int var0);

    static native int stat(String var0, stat var1);

    static native int lstat(String var0, stat var1);

    static native int symlink(String var0, String var1);

    static {
        NativeLibLoader.loadLibrary("jpathwatch-native");
        EINTR = Unix.getIntDefine("EINTR");
        EINVAL = Unix.getIntDefine("EINVAL");
        EBADF = Unix.getIntDefine("EBADF");
        ENOENT = Unix.getIntDefine("ENOENT");
        O_RDONLY = Unix.getIntDefine("O_RDONLY");
        O_WRONLY = Unix.getIntDefine("O_WRONLY");
        O_RDWR = Unix.getIntDefine("O_RDWR");
        O_APPEND = Unix.getIntDefine("O_APPEND");
        O_CREAT = Unix.getIntDefine("O_CREAT");
        O_EXCL = Unix.getIntDefine("O_EXCL");
        O_NOCTTY = Unix.getIntDefine("O_NOCTTY");
        O_NONBLOCK = Unix.getIntDefine("O_NONBLOCK");
        O_SYNC = Unix.getIntDefine("O_SYNC");
        O_TRUNC = Unix.getIntDefine("O_TRUNC");
        S_ISUID = Unix.getIntDefine("S_ISUID");
        S_ISGID = Unix.getIntDefine("S_ISGID");
        S_IRWXU = Unix.getIntDefine("S_IRWXU");
        S_IRUSR = Unix.getIntDefine("S_IRUSR");
        S_IWUSR = Unix.getIntDefine("S_IWUSR");
        S_IXUSR = Unix.getIntDefine("S_IXUSR");
        S_IRWXG = Unix.getIntDefine("S_IRWXG");
        S_IRGRP = Unix.getIntDefine("S_IRGRP");
        S_IWGRP = Unix.getIntDefine("S_IWGRP");
        S_IXGRP = Unix.getIntDefine("S_IXGRP");
        S_IRWXO = Unix.getIntDefine("S_IRWXO");
        S_IROTH = Unix.getIntDefine("S_IROTH");
        S_IWOTH = Unix.getIntDefine("S_IWOTH");
        S_IXOTH = Unix.getIntDefine("S_IXOTH");
    }

    static class stat {
        int st_dev;
        long st_ino;
        int st_mode;
        int st_nlink;
        int st_uid;
        int st_gid;
        int st_rdev;
        long st_size;
        int st_blksize;
        long st_blocks;
        long st_atime;
        long st_mtime;
        long st_ctime;

        stat() {
        }

        private void set(int dev, long ino, int mode, int nlink, int uid, int gid, int rdev, long size, int blksize, long blocks, long atime, long mtime, long ctime) {
            this.st_dev = dev;
            this.st_ino = ino;
            this.st_mode = mode;
            this.st_nlink = nlink;
            this.st_uid = uid;
            this.st_gid = gid;
            this.st_rdev = rdev;
            this.st_size = size;
            this.st_blksize = blksize;
            this.st_blocks = blocks;
            this.st_atime = atime;
            this.st_mtime = mtime;
            this.st_ctime = ctime;
        }
    }

    public static class timespec {
        private long peer = timespec.createPeer();

        private static native void initNative();

        private static native long createPeer();

        private static native void destroyPeer(long var0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                timespec.destroyPeer(this.peer);
                this.peer = 0L;
            }
            finally {
                super.finalize();
            }
        }

        public native long get_tv_sec();

        public native long get_tv_nsec();

        public native void set_tv_sec(long var1);

        public native void set_tv_nsec(long var1);

        public native void set(long var1, long var3);

        static {
            timespec.initNative();
        }
    }
}

