/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FieldComparatorFactory;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.fill.DatasetFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class FieldFilter
implements DatasetFilter {
    private String field;
    private String filterValueStart;
    private String filterValueEnd;
    private String filterType;
    private String filterTypeOperator;
    private String filterPattern;
    private String localeCode;
    private String timeZoneId;
    private DatasetFillContext context;
    private Boolean isValid;
    private Boolean isField;
    private FilterTypesEnum filterTypeEnum;
    private AbstractFieldComparator<?> fieldComparator;

    public FieldFilter() {
    }

    public FieldFilter(String field, String filterValueStart, String filterValueEnd, String filterType, String filterTypeOperator) {
        this.field = field;
        this.filterValueStart = filterValueStart;
        this.filterValueEnd = filterValueEnd;
        this.filterType = filterType;
        this.filterTypeOperator = filterTypeOperator;
    }

    @Override
    public void init(DatasetFillContext context) {
        this.context = context;
        this.filterTypeEnum = FilterTypesEnum.getByName(this.filterType);
        if (this.fieldComparator == null) {
            Locale locale = this.getFilterLocale();
            TimeZone timeZone = this.getFilterTimeZone();
            this.fieldComparator = FieldComparatorFactory.createFieldComparator(this.filterTypeEnum, this.filterPattern, locale, timeZone);
        }
    }

    protected Locale getFilterLocale() {
        Locale locale = this.localeCode != null ? JRDataUtils.getLocale(this.localeCode) : (this.context.getLocale() != null ? this.context.getLocale() : Locale.getDefault());
        return locale;
    }

    protected TimeZone getFilterTimeZone() {
        TimeZone timeZone = this.timeZoneId != null ? JRDataUtils.getTimeZone(this.timeZoneId) : (TimeZone)this.context.getParameterValue("REPORT_TIME_ZONE");
        return timeZone;
    }

    @Override
    public boolean matches(EvaluationType evaluation) {
        Object value;
        if (this.isField == null || Boolean.TRUE.equals(this.isField)) {
            value = this.context.getFieldValue(this.field, evaluation);
            this.fieldComparator.setCompareToClass(((JRFillDataset)this.context).getFillField(this.field).getValueClass());
        } else {
            value = this.context.getVariableValue(this.field, evaluation);
            this.fieldComparator.setCompareToClass(((JRFillDataset)this.context).getFillVariable(this.field).getValueClass());
        }
        this.fieldComparator.setValueStart(this.filterValueStart);
        this.fieldComparator.setValueEnd(this.filterValueEnd);
        this.fieldComparator.setCompareTo(value);
        if (this.isValid == null) {
            this.isValid = this.fieldComparator.isValid();
        }
        if (!this.isValid.booleanValue()) {
            return true;
        }
        return this.fieldComparator.compare(this.filterTypeOperator);
    }

    public String getField() {
        return this.field;
    }

    public String getFilterValueStart() {
        return this.filterValueStart;
    }

    public void setFilterValueStart(String filterValueStart) {
        this.filterValueStart = filterValueStart;
    }

    public String getFilterValueEnd() {
        return this.filterValueEnd;
    }

    public void setFilterValueEnd(String filterValueEnd) {
        this.filterValueEnd = filterValueEnd;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public String getFilterTypeOperator() {
        return this.filterTypeOperator;
    }

    public void setFilterTypeOperator(String filterTypeOperator) {
        this.filterTypeOperator = filterTypeOperator;
    }

    public FilterTypesEnum getFilterTypeEnum() {
        return this.filterTypeEnum;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Boolean getIsField() {
        return this.isField;
    }

    public void setIsField(Boolean isField) {
        this.isField = isField;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }
}

