/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.charts.util.CategoryChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.components.charts.AbstractChartCustomizer;
import net.sf.jasperreports.components.charts.ChartCustomizer;
import net.sf.jasperreports.components.charts.FillChartSettings;
import net.sf.jasperreports.components.spiderchart.FillSpiderDataset;
import net.sf.jasperreports.components.spiderchart.FillSpiderPlot;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.SpiderChartRendererEvaluator;
import net.sf.jasperreports.components.spiderchart.SpiderChartSharedBean;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.renderers.Renderable;

public class FillSpiderChart
extends BaseFillComponent
implements JRFillCloneable {
    public static final String EXCEPTION_MESSAGE_KEY_CUSTOMIZER_INSTANCE_ERROR = "components.spiderchart.customizer.instance.error";
    private final SpiderChartComponent chartComponent;
    private final FillChartSettings chartSettings;
    private final FillSpiderDataset dataset;
    private final FillSpiderPlot plot;
    private Double maxValue;
    private String titleText;
    private String subtitleText;
    private String anchorName;
    private String hyperlinkReference;
    private Boolean hyperlinkWhen;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    private JRFillExpressionEvaluator expressionEvaluator;
    private ChartHyperlinkProvider chartHyperlinkProvider;
    private Renderable renderer;
    private String customizerClass;
    protected ChartCustomizer chartCustomizer;

    public FillSpiderChart(SpiderChartComponent chartComponent, JRFillObjectFactory factory) {
        this.chartComponent = chartComponent;
        this.chartSettings = new FillChartSettings(chartComponent.getChartSettings(), factory);
        this.dataset = new FillSpiderDataset((SpiderDataset)chartComponent.getDataset(), factory);
        factory.registerElementDataset(this.dataset);
        this.plot = new FillSpiderPlot((SpiderPlot)chartComponent.getPlot(), factory);
        this.expressionEvaluator = factory.getExpressionEvaluator();
    }

    protected boolean isEvaluateNow() {
        return this.chartComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateRenderer(evaluation);
        }
    }

    protected void evaluateRenderer(byte evaluation) throws JRException {
        this.maxValue = (Double)this.fillContext.evaluate(this.getPlot().getMaxValueExpression(), evaluation);
        this.titleText = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getTitleExpression(), evaluation));
        this.subtitleText = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getSubtitleExpression(), evaluation));
        this.anchorName = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getAnchorNameExpression(), evaluation));
        this.hyperlinkReference = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getHyperlinkReferenceExpression(), evaluation));
        this.hyperlinkWhen = (Boolean)this.fillContext.evaluate(this.getChartSettings().getHyperlinkWhenExpression(), evaluation);
        this.hyperlinkAnchor = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getHyperlinkAnchorExpression(), evaluation));
        this.hyperlinkPage = (Integer)this.fillContext.evaluate(this.getChartSettings().getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = JRStringUtil.getString(this.fillContext.evaluate(this.getChartSettings().getHyperlinkTooltipExpression(), evaluation));
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this.getChartSettings(), this.expressionEvaluator, evaluation);
        this.dataset.evaluateDatasetRun(evaluation);
        this.dataset.finishDataset();
        this.chartHyperlinkProvider = new CategoryChartHyperlinkProvider(this.dataset.getItemHyperlinks());
        JRComponentElement element = this.fillContext.getComponentElement();
        SpiderChartSharedBean spiderChartSharedBean = new SpiderChartSharedBean(this.getChartSettings().getRenderType(), this.maxValue, this.titleText, this.subtitleText, this.chartHyperlinkProvider, this.dataset);
        this.customizerClass = this.chartSettings.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class<?> myClass = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (ChartCustomizer)myClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CUSTOMIZER_INSTANCE_ERROR, null, e);
            }
            if (this.chartCustomizer instanceof AbstractChartCustomizer) {
                ((AbstractChartCustomizer)this.chartCustomizer).init(this.fillContext.getFiller(), this.getDataset());
            }
        }
        this.renderer = SpiderChartRendererEvaluator.evaluateRenderable(this.fillContext.getFiller().getJasperReportsContext(), element, spiderChartSharedBean, this.chartCustomizer, "draw", "fillDataset");
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateImage templateImage = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
        templateImage.setStyle(this.fillContext.getElementStyle());
        templateImage.setLinkType(this.getLinkType());
        templateImage.setLinkTarget(this.getLinkTarget());
        templateImage.setUsingCache(false);
        templateImage = this.deduplicate(templateImage);
        JRTemplatePrintImage image = new JRTemplatePrintImage(templateImage, this.printElementOriginator);
        image.setUUID(element.getUUID());
        image.setX(element.getX());
        image.setY(this.fillContext.getElementPrintY());
        image.setWidth(element.getWidth());
        image.setHeight(element.getHeight());
        image.setBookmarkLevel(this.getBookmarkLevel());
        if (this.isEvaluateNow()) {
            this.copy(image);
        } else {
            this.fillContext.registerDelayedEvaluation(image, this.chartComponent.getEvaluationTime(), this.chartComponent.getEvaluationGroup());
        }
        return image;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateRenderer(evaluation);
        this.copy((JRPrintImage)element);
        this.fillContext.getFiller().updateBookmark(element);
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderable());
        printImage.setAnchorName(this.getAnchorName());
        if (this.getChartSettings().getHyperlinkWhenExpression() == null || Boolean.TRUE.equals(this.hyperlinkWhen)) {
            printImage.setHyperlinkReference(this.getHyperlinkReference());
            printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
            printImage.setHyperlinkPage(this.getHyperlinkPage());
            printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
            printImage.setHyperlinkParameters(this.hyperlinkParameters);
        } else {
            if (printImage instanceof JRTemplatePrintImage) {
                ((JRTemplatePrintImage)printImage).setHyperlinkOmitted(true);
            }
            printImage.setHyperlinkReference(null);
        }
    }

    protected ChartHyperlinkProvider getHyperlinkProvider() {
        return this.chartHyperlinkProvider;
    }

    public FillChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public FillSpiderDataset getDataset() {
        return this.dataset;
    }

    public FillSpiderPlot getPlot() {
        return this.plot;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getSubtitleText() {
        return this.subtitleText;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public int getBookmarkLevel() {
        return this.getChartSettings().getBookmarkLevel();
    }

    public JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public Renderable getRenderable() {
        return this.renderer;
    }

    public String getLinkType() {
        return this.getChartSettings().getLinkType();
    }

    public String getLinkTarget() {
        return this.getChartSettings().getLinkTarget();
    }

    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }
}

