/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RackElementType {
    PATCH_PANEL(0),
    FILLER_PANEL(1),
    ORGANISER(2);

    private static Logger logger;
    private static Map<Integer, RackElementType> lookupTable;
    private int value;

    private RackElementType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackElementType getByValue(int value) {
        RackElementType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FILLER_PANEL;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(RackElementType.class);
        lookupTable = new HashMap<Integer, RackElementType>();
        for (RackElementType element : RackElementType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

