/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE = "charts.chart.type.unsupported";
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_CHART_TYPE = "chartType";
    public static final String PROPERTY_CUSTOMIZER_CLASS = "customizerClass";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_LEGEND_FONT = "legendFont";
    public static final String PROPERTY_SUBTITLE_EXPRESSION = "subtitleExpression";
    public static final String PROPERTY_SUBTITLE_FONT = "subtitleFont";
    public static final String PROPERTY_TITLE_EXPRESSION = "titleExpression";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    protected byte chartType;
    protected Boolean showLegend;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    protected Color titleColor;
    protected Color subtitleColor;
    protected Color legendColor;
    protected Color legendBackgroundColor;
    protected String renderType;
    protected String theme;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected EdgeEnum legendPositionValue;
    protected EdgeEnum titlePositionValue;
    protected String customizerClass;
    protected JRGroup evaluationGroup;
    protected JRExpression titleExpression;
    protected JRExpression subtitleExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    private List<JRHyperlinkParameter> hyperlinkParameters;
    protected JRChartDataset dataset;
    protected JRChartPlot plot;
    protected JRLineBox lineBox;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 61100;
    private boolean isShowLegend;
    private byte titlePosition;
    private byte legendPosition;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;
    private Byte legendPositionByte;
    private Byte titlePositionByte;

    public JRDesignChart(JRDefaultStyleProvider defaultStyleProvider, byte chartType) {
        super(defaultStyleProvider);
        this.setChartType(chartType);
        this.hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
        this.lineBox = new JRBaseLineBox(this);
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange("isShowLegend", old, this.showLegend);
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange("renderType", old, this.renderType);
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange("theme", old, this.theme);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTimeValue;
        this.evaluationTimeValue = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTimeValue);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup group) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = group;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont font) {
        JRFont old = this.titleFont;
        this.titleFont = font;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_FONT, old, this.titleFont);
    }

    @Override
    public EdgeEnum getTitlePositionValue() {
        return this.titlePositionValue;
    }

    @Override
    public void setTitlePosition(EdgeEnum titlePositionValue) {
        EdgeEnum old = this.titlePositionValue;
        this.titlePositionValue = titlePositionValue;
        this.getEventSupport().firePropertyChange("titlePosition", old, this.titlePositionValue);
    }

    @Override
    public Color getTitleColor() {
        return this.getStyleResolver().getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange("titleColor", old, this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont font) {
        JRFont old = this.subtitleFont;
        this.subtitleFont = font;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_FONT, old, this.subtitleFont);
    }

    @Override
    public Color getSubtitleColor() {
        return this.getStyleResolver().getSubtitleColor(this);
    }

    @Override
    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange("subtitleColor", old, this.subtitleColor);
    }

    @Override
    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    @Override
    public Color getLegendColor() {
        return this.getStyleResolver().getLegendColor(this);
    }

    @Override
    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange("legendColor", old, this.legendColor);
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.getStyleResolver().getLegendBackgroundColor(this);
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange("legendBackgroundColor", old, this.legendBackgroundColor);
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont legendFont) {
        JRFont old = this.legendFont;
        this.legendFont = legendFont;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_FONT, old, this.legendFont);
    }

    @Override
    public EdgeEnum getLegendPositionValue() {
        return this.legendPositionValue;
    }

    @Override
    public void setLegendPosition(EdgeEnum legendPositionValue) {
        EdgeEnum old = this.legendPositionValue;
        this.legendPositionValue = legendPositionValue;
        this.getEventSupport().firePropertyChange("legendPosition", old, this.legendPositionValue);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression expression) {
        JRExpression old = this.titleExpression;
        this.titleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_EXPRESSION, old, this.titleExpression);
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression expression) {
        JRExpression old = this.subtitleExpression;
        this.subtitleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_EXPRESSION, old, this.subtitleExpression);
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange("hyperlinkWhenExpression", old, this.hyperlinkWhenExpression);
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte chartType) {
        byte old = this.chartType;
        this.chartType = chartType;
        switch (chartType) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot, this);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot, this);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot, this);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 17: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot, this);
                break;
            }
            case 19: {
                this.dataset = null;
                this.plot = new JRDesignMultiAxisPlot(this.plot, this);
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot, this);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot, this);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot, this);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 18: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot, this);
                break;
            }
            case 16: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot, this);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 20: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 21: {
                this.dataset = new JRDesignGanttDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE, (Object[])null);
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_TYPE, old, this.chartType);
    }

    public void setDataset(JRChartDataset ds) {
        JRChartDataset old = this.dataset;
        this.dataset = ds;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        String old = this.customizerClass;
        this.customizerClass = customizerClass;
        this.getEventSupport().firePropertyChange(PROPERTY_CUSTOMIZER_CLASS, old, this.customizerClass);
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("hyperlinkType", old, this.linkType);
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRDesignChart clone = (JRDesignChart)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.titleExpression = JRCloneUtils.nullSafeClone(this.titleExpression);
        clone.subtitleExpression = JRCloneUtils.nullSafeClone(this.subtitleExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.plot = this.plot == null ? null : (JRChartPlot)this.plot.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPosition);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePosition);
                this.showLegend = this.isShowLegend;
            } else {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPositionByte);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePositionByte);
                this.legendPositionByte = null;
                this.titlePositionByte = null;
            }
        }
    }
}

