/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.console.dialogs.SetEntryEditDialog;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.SetEditor;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RulePStorage
extends PropertyPage {
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private SetEditor sEditor;
    private SortableTableViewer viewerDeleteValue;
    private Button addDeleteValueButton;
    private Button editDeleteValueButton;
    private Button removeDeleteValueButton;
    private List<String> pStorageDelete = new ArrayList<String>();

    protected Control createContents(Composite parent) {
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        this.pStorageDelete.addAll(this.rule.getPStorageDelete());
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        int vInd = 2;
        Label label = new Label(dialogArea, 0);
        label.setText("Set persistent storage values");
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.sEditor = new SetEditor(dialogArea, 0);
        this.sEditor.putAll(this.rule.getPStorageSet());
        gd = new GridData();
        gd.verticalIndent = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.sEditor.setLayoutData((Object)gd);
        label = new Label(dialogArea, 0);
        label.setText("Delete persistent storage entries");
        gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        String[] deleteColumnNames = new String[]{"Key"};
        int[] deleteColumnWidths = new int[]{150};
        this.viewerDeleteValue = new SortableTableViewer(dialogArea, deleteColumnNames, deleteColumnWidths, 0, 128, 67586);
        this.viewerDeleteValue.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerDeleteValue.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewerDeleteValue.getLabelProvider()));
        this.viewerDeleteValue.setInput((Object)this.pStorageDelete.toArray());
        this.viewerDeleteValue.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)RulePStorage.this.viewerDeleteValue.getSelection()).size();
                RulePStorage.this.editDeleteValueButton.setEnabled(size == 1);
                RulePStorage.this.removeDeleteValueButton.setEnabled(size > 0);
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewerDeleteValue.getControl().setLayoutData((Object)gd);
        Composite buttonsDeleteValue = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsDeleteValue.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsDeleteValue.setLayoutData((Object)gd);
        this.addDeleteValueButton = new Button(buttonsDeleteValue, 8);
        this.addDeleteValueButton.setText("Add");
        this.addDeleteValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RulePStorage.this.addPStorageDeleteAction();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addDeleteValueButton.setLayoutData((Object)rd);
        this.editDeleteValueButton = new Button(buttonsDeleteValue, 8);
        this.editDeleteValueButton.setText("Edit");
        this.editDeleteValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RulePStorage.this.editPStorageDeleteAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editDeleteValueButton.setLayoutData((Object)rd);
        this.editDeleteValueButton.setEnabled(false);
        this.removeDeleteValueButton = new Button(buttonsDeleteValue, 8);
        this.removeDeleteValueButton.setText("Delete");
        this.removeDeleteValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RulePStorage.this.deletePStorageDeleteAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.removeDeleteValueButton.setLayoutData((Object)rd);
        this.removeDeleteValueButton.setEnabled(false);
        return dialogArea;
    }

    private void addPStorageDeleteAction() {
        SetEntryEditDialog dlg = new SetEntryEditDialog(this.getShell(), null, null, false, false);
        if (dlg.open() == 0) {
            this.pStorageDelete.add(dlg.getAtributeName());
            this.viewerDeleteValue.setInput((Object)this.pStorageDelete.toArray());
        }
    }

    private void editPStorageDeleteAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerDeleteValue.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String attr = (String)selection.getFirstElement();
        SetEntryEditDialog dlg = new SetEntryEditDialog(this.getShell(), attr, null, false, false);
        if (dlg.open() == 0) {
            this.pStorageDelete.set(this.pStorageDelete.indexOf(attr), dlg.getAtributeName());
            this.viewerDeleteValue.setInput((Object)this.pStorageDelete.toArray());
        }
    }

    private void deletePStorageDeleteAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerDeleteValue.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String e = (String)it.next();
                this.pStorageDelete.remove(e);
            }
            this.viewerDeleteValue.setInput((Object)this.pStorageDelete.toArray());
        }
    }

    private void doApply() {
        this.rule.setPStorageSet(this.sEditor.getSet());
        this.rule.setPStorageDelete(this.pStorageDelete);
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

