/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ScheduledTask;
import org.netxms.client.server.ServerFile;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.SelectServerFileDialog;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.ScheduleSelector;

public class StartServerToAgentFileUploadDialog
extends Dialog {
    private TableViewer fileList;
    private Button buttonAddFile;
    private Button buttonRemoveFile;
    private LabeledText textRemoteFile;
    private Button checkJobOnHold;
    private Button checkIsSchedule;
    private ScheduleSelector scheduleSelector;
    private List<ServerFile> serverFiles = new ArrayList<ServerFile>();
    private String remoteFileName;
    private boolean createJobOnHold;
    private boolean scheduledTask;
    private ScheduledTask schedule;
    private boolean canScheduleFileUpload;

    public StartServerToAgentFileUploadDialog(Shell parentShell, boolean canScheduleFileUpload) {
        super(parentShell);
        this.canScheduleFileUpload = canScheduleFileUpload;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.StartServerToAgentFileUploadDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.StartServerToAgentFileUploadDialog_ServerFile);
        this.fileList = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.heightHint = 150;
        this.fileList.getControl().setLayoutData((Object)gd);
        this.fileList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ServerFile)element).getName();
            }
        });
        this.fileList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ServerFile)e1).getName().compareToIgnoreCase(((ServerFile)e2).getName());
            }
        });
        this.fileList.setInput(this.serverFiles);
        Composite buttonArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        buttonArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAddFile = new Button(buttonArea, 8);
        this.buttonAddFile.setText("&Add...");
        gd = new GridData();
        gd.widthHint = 90;
        this.buttonAddFile.setLayoutData((Object)gd);
        this.buttonAddFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServerFileDialog dlg = new SelectServerFileDialog(StartServerToAgentFileUploadDialog.this.getShell(), true);
                if (dlg.open() == 0) {
                    ServerFile[] serverFileArray = dlg.getSelectedFiles();
                    int n = serverFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServerFile f = serverFileArray[n2];
                        boolean found = false;
                        for (ServerFile sf : StartServerToAgentFileUploadDialog.this.serverFiles) {
                            if (!sf.getName().equals(f.getName())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            StartServerToAgentFileUploadDialog.this.serverFiles.add(f);
                        }
                        ++n2;
                    }
                    StartServerToAgentFileUploadDialog.this.fileList.refresh();
                }
            }
        });
        this.buttonRemoveFile = new Button(buttonArea, 8);
        this.buttonRemoveFile.setText("&Remove");
        gd = new GridData();
        gd.widthHint = 90;
        this.buttonRemoveFile.setLayoutData((Object)gd);
        this.buttonRemoveFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)StartServerToAgentFileUploadDialog.this.fileList.getSelection();
                for (Object o : selection.toList()) {
                    StartServerToAgentFileUploadDialog.this.serverFiles.remove(o);
                }
                StartServerToAgentFileUploadDialog.this.fileList.refresh();
            }
        });
        this.textRemoteFile = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textRemoteFile.setLabel(Messages.StartServerToAgentFileUploadDialog_RemoteFileName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRemoteFile.setLayoutData((Object)gd);
        this.checkJobOnHold = new Button(dialogArea, 32);
        Messages.get();
        this.checkJobOnHold.setText(Messages.StartServerToAgentFileUploadDialog_CreateJobOnHold);
        this.checkJobOnHold.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StartServerToAgentFileUploadDialog.this.checkIsSchedule.setEnabled(!StartServerToAgentFileUploadDialog.this.checkJobOnHold.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.canScheduleFileUpload) {
            this.checkIsSchedule = new Button(dialogArea, 32);
            Messages.get();
            this.checkIsSchedule.setText(Messages.StartServerToAgentFileUploadDialog_ScheduleTask);
            this.checkIsSchedule.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StartServerToAgentFileUploadDialog.this.checkJobOnHold.setEnabled(!StartServerToAgentFileUploadDialog.this.checkIsSchedule.getSelection());
                    StartServerToAgentFileUploadDialog.this.scheduleSelector.setEnabled(StartServerToAgentFileUploadDialog.this.checkIsSchedule.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.scheduleSelector = new ScheduleSelector(dialogArea, 0);
            this.scheduleSelector.setEnabled(false);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.scheduledTask = this.checkIsSchedule.getSelection();
        if (this.scheduledTask) {
            this.schedule = this.scheduleSelector.getSchedule();
        }
        if (this.serverFiles.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.StartServerToAgentFileUploadDialog_Warning, (String)Messages.StartServerToAgentFileUploadDialog_WarningText);
            return;
        }
        this.remoteFileName = this.textRemoteFile.getText().trim();
        this.createJobOnHold = this.checkJobOnHold.getSelection();
        super.okPressed();
    }

    public List<ServerFile> getServerFiles() {
        return this.serverFiles;
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public boolean isCreateJobOnHold() {
        return this.createJobOnHold;
    }

    public boolean isScheduled() {
        return this.scheduledTask;
    }

    public ScheduledTask getScheduledTask() {
        return this.schedule;
    }
}

