/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.MutableObjectCategory;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Activator;
import org.netxms.ui.eclipse.objectmanager.dialogs.ObjectCategoryEditDialog;
import org.netxms.ui.eclipse.objectmanager.views.helpers.ObjectCategoryComparator;
import org.netxms.ui.eclipse.objectmanager.views.helpers.ObjectCategoryFilter;
import org.netxms.ui.eclipse.objectmanager.views.helpers.ObjectCategoryLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectCategoryManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.objectmanager.views.ObjectCategoryManager";
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_ICON = 2;
    public static final int COL_MAP_IMAGE = 3;
    private static final String TABLE_CONFIG_PREFIX = "ObjectCategoryManager";
    private Map<Integer, ObjectCategory> categories = new HashMap<Integer, ObjectCategory>();
    private Display display;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Composite content;
    private FilterText filterText;
    private ObjectCategoryFilter filter;
    private boolean initShowFilter = true;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionShowFilter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initShowFilter = ObjectCategoryManager.getBooleanSetting("ObjectTools.showFilter", this.initShowFilter);
        this.session = ConsoleSharedData.getSession();
    }

    private static boolean getBooleanSetting(String name, boolean defval) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(name) == null) {
            return defval;
        }
        return settings.getBoolean(name);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.content = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        this.content.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectCategoryManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ObjectCategoryManager.this.enableFilter(false);
                ObjectCategoryManager.this.actionShowFilter.setChecked(ObjectCategoryManager.this.initShowFilter);
            }
        });
        String[] names = new String[]{"ID", "Name", "Icon", "Map image"};
        int[] widths = new int[]{100, 500, 200, 200};
        this.viewer = new SortableTableViewer(this.content, names, widths, 1, 1024, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectCategoryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectCategoryComparator());
        this.filter = new ObjectCategoryFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ObjectCategoryManager.this.actionEdit.setEnabled(selection.size() == 1);
                    ObjectCategoryManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectCategoryManager.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ObjectCategoryManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ObjectCategoryManager.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.session.addListener((SessionListener)this);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 1048) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectCategory category = (ObjectCategory)n.getObject();
                    ObjectCategoryManager.this.categories.put(category.getId(), category);
                    ObjectCategoryManager.this.viewer.refresh(true);
                }
            });
        } else if (n.getCode() == 1049) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectCategoryManager.this.categories.remove((int)n.getSubCode());
                    ObjectCategoryManager.this.viewer.refresh();
                }
            });
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectmanager.context.ObjectCategoryManager");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionShowFilter = new Action("Show &filter", 2){

            public void run() {
                ObjectCategoryManager.this.enableFilter(!ObjectCategoryManager.this.initShowFilter);
                ObjectCategoryManager.this.actionShowFilter.setChecked(ObjectCategoryManager.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objectmanager.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ObjectCategoryManager.this.refresh();
            }
        };
        this.actionNew = new Action("New..."){

            public void run() {
                ObjectCategoryManager.this.createCategory();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new Action("&Edit..."){

            public void run() {
                ObjectCategoryManager.this.editCategory();
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionDelete = new Action("&Delete"){

            public void run() {
                ObjectCategoryManager.this.deleteCategories();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectCategoryManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    private void createCategory() {
        ObjectCategoryEditDialog dlg = new ObjectCategoryEditDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            this.updateCategory(dlg.getCategory());
        }
    }

    private void editCategory() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectCategoryEditDialog dlg = new ObjectCategoryEditDialog(this.getSite().getShell(), new MutableObjectCategory((ObjectCategory)selection.getFirstElement()));
        if (dlg.open() == 0) {
            this.updateCategory(dlg.getCategory());
        }
    }

    private void updateCategory(final MutableObjectCategory category) {
        new ConsoleJob("Modify object category", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final int id = ObjectCategoryManager.this.session.modifyObjectCategory(category);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectCategory newCategory = (ObjectCategory)ObjectCategoryManager.this.categories.get(id);
                        if (newCategory == null) {
                            newCategory = new ObjectCategory((ObjectCategory)category);
                            ObjectCategoryManager.this.categories.put(id, newCategory);
                        }
                        ObjectCategoryManager.this.viewer.refresh();
                        ObjectCategoryManager.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newCategory));
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot modify object category";
            }
        }.start();
    }

    private void deleteCategories() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Object Categories", (String)"Selected object categories will be deleted. Are you sure?")) {
            return;
        }
        final int[] idList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            idList[index++] = ((ObjectCategory)o).getId();
        }
        new ConsoleJob("Delete object categories", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask("Delete object categories", idList.length);
                int[] nArray = idList;
                int n = idList.length;
                int n2 = 0;
                while (n2 < n) {
                    block4: {
                        final int id = nArray[n2];
                        try {
                            ObjectCategoryManager.this.session.deleteObjectCategory(id, false);
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() != 122) {
                                throw e;
                            }
                            final boolean[] retry = new boolean[1];
                            this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ObjectCategory c = ObjectCategoryManager.this.session.getObjectCategory(id);
                                    retry[0] = MessageDialogHelper.openQuestion((Shell)ObjectCategoryManager.this.getSite().getShell(), (String)"Confirm Delete", (String)String.format("Object category \"%s\" is in use. Are you sure you want to delete it?", c.getName()));
                                }
                            });
                            if (!retry[0]) break block4;
                            ObjectCategoryManager.this.session.deleteObjectCategory(id, true);
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot delete object category";
            }
        }.start();
    }

    private void refresh() {
        this.categories.clear();
        for (ObjectCategory c : this.session.getObjectCategories()) {
            this.categories.put(c.getId(), c);
        }
        this.viewer.setInput(this.categories.values());
    }
}

