/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectList;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ZoneCommunications
extends PropertyPage {
    private Zone zone;
    private ObjectList proxyNodes = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.getElement().getAdapter(Zone.class);
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new FillLayout());
        Messages.get();
        this.proxyNodes = new ObjectList(dialogArea, 0, Messages.ZoneCommunications_ProxyNodes, (Collection)this.zone.getProxyNodes(), AbstractNode.class, new Runnable(){

            @Override
            public void run() {
                ZoneCommunications.this.isModified = true;
            }
        });
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.zone.getObjectId());
        md.setZoneProxies(this.proxyNodes.getObjectIdentifiers());
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.ZoneCommunications_JobName, this.zone.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ZoneCommunications_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ZoneCommunications.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.isModified = true;
        this.proxyNodes.clear();
    }
}

