/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.ProgressMonitorUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressMonitorFocusJobDialog
extends ProgressMonitorJobsDialog {
    Job job;
    private boolean showDialog;

    public ProgressMonitorFocusJobDialog(Shell parentShell) {
        super(parentShell == null ? ProgressManagerUtil.getNonModalShell() : parentShell);
        this.setShellStyle(ProgressMonitorFocusJobDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10 | 0x400);
        this.setCancelable(true);
        this.enableDetailsButton = true;
    }

    protected void cancelPressed() {
        this.job.cancel();
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.job.getName());
        shell.addTraverseListener(e -> {
            if (e.detail == 2) {
                this.cancelPressed();
                e.detail = 0;
                e.doit = true;
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button runInWorkspace = this.createButton(parent, 12, ProgressMessages.ProgressMonitorFocusJobDialog_RunInBackgroundButton, true);
        runInWorkspace.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.FALSE);
            this.finishedRun();
        }));
        runInWorkspace.setCursor(this.arrowCursor);
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.setCursor(this.arrowCursor);
        this.createDetailsButton(parent);
    }

    private IJobChangeListener createCloseListener() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (ProgressMonitorFocusJobDialog.this.getShell() == null) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell currentShell = ProgressMonitorFocusJobDialog.this.getShell();
                    if (currentShell == null || currentShell.isDisposed()) {
                        return;
                    }
                    ProgressMonitorFocusJobDialog.this.finishedRun();
                });
            }
        };
    }

    public int open() {
        int result = super.open();
        IJobChangeListener listener = this.createCloseListener();
        this.job.addJobChangeListener(listener);
        if (this.job.getState() == 0) {
            this.job.removeJobChangeListener(listener);
            this.finishedRun();
            this.cleanUpFinishedJob();
        }
        return result;
    }

    public void show(Job jobToWatch, final Shell originatingShell) {
        this.job = jobToWatch;
        this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.TRUE);
        this.setOpenOnRun(false);
        this.aboutToRun();
        final Object jobIsDone = new Object();
        JobChangeAdapter jobListener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = jobIsDone;
                synchronized (object) {
                    jobIsDone.notify();
                }
            }
        };
        this.job.addJobChangeListener((IJobChangeListener)jobListener);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
            try {
                Object object2 = jobIsDone;
                synchronized (object2) {
                    if (this.job.getState() != 0) {
                        jobIsDone.wait(ProgressManagerUtil.SHORT_OPERATION_TIME);
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        });
        this.job.removeJobChangeListener((IJobChangeListener)jobListener);
        final WorkbenchJob openJob = new WorkbenchJob(ProgressMessages.ProgressMonitorFocusJobDialog_UserDialogJob){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ProgressMonitorFocusJobDialog.this.job.getState() == 0) {
                    return Status.CANCEL_STATUS;
                }
                if (!ProgressManagerUtil.safeToOpen(ProgressMonitorFocusJobDialog.this, originatingShell)) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressMonitorFocusJobDialog.this.getParentShell() != null && ProgressMonitorFocusJobDialog.this.getParentShell().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ProgressManager.JobMonitor jobMonitor = ProgressManager.getInstance().progressFor(ProgressMonitorFocusJobDialog.this.job);
                Display d = Display.getCurrent();
                IProgressMonitorWithBlocking wrapper = ProgressMonitorUtil.createAccumulatingProgressMonitor((IProgressMonitor)ProgressMonitorFocusJobDialog.this.getProgressMonitor(), (Display)d);
                jobMonitor.addProgressListener((IProgressMonitor)wrapper);
                ProgressMonitorFocusJobDialog.this.open();
                return Status.OK_STATUS;
            }
        };
        openJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                openJob.removeJobChangeListener((IJobChangeListener)this);
                IStatus result = openJob.getResult();
                if (result != null && result == Status.CANCEL_STATUS) {
                    ProgressMonitorFocusJobDialog.this.finishedRun();
                    ProgressMonitorFocusJobDialog.this.cleanUpFinishedJob();
                }
            }
        });
        openJob.setSystem(true);
        openJob.schedule();
    }

    private void cleanUpFinishedJob() {
        ProgressManager.getInstance().checkForStaleness(this.job);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        this.getProgressMonitor().setTaskName(ProgressManager.getInstance().progressFor(this.job).getJobInfo().getDisplayString());
        return area;
    }

    @Override
    protected void createExtendedDialogArea(Composite parent) {
        this.showDialog = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
        Button showUserDialogButton = new Button(parent, 32);
        showUserDialogButton.setText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundButton);
        showUserDialogButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundToolTip);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        showUserDialogButton.setLayoutData((Object)gd);
        showUserDialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.showDialog = showUserDialogButton.getSelection();
        }));
        super.createExtendedDialogArea(parent);
    }

    @Override
    public boolean close() {
        if (this.getReturnCode() != 1) {
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("RUN_IN_BACKGROUND", this.showDialog);
        }
        return super.close();
    }
}

