/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;

public class LocalCommandExecutor
extends AbstractObjectToolExecutor {
    private Process process;
    private boolean processRunning = false;
    private String command;
    private Object mutex = new Object();

    public LocalCommandExecutor(Composite resultArea, ViewPart view, ObjectContext objectContext, AbstractObjectToolExecutor.ActionSet actionSet, String command) {
        super(resultArea, view, objectContext, actionSet);
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.processRunning) {
                this.process.destroy();
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.processRunning = true;
            this.setRunning(true);
        }
        final IOConsoleOutputStream out = this.console.newOutputStream();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LocalCommandResults_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.LocalCommandResults_JobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LocalCommandExecutor.this.process = Runtime.getRuntime().exec(LocalCommandExecutor.this.command);
                InputStream in = LocalCommandExecutor.this.process.getInputStream();
                try {
                    try {
                        int bytes;
                        byte[] data = new byte[16384];
                        boolean isWindows = Platform.getOS().equals("win32");
                        while ((bytes = in.read(data)) != -1) {
                            String s = new String(Arrays.copyOf(data, bytes));
                            if (isWindows) {
                                out.write(s.replace("\r\r\n", " \r\n"));
                                continue;
                            }
                            out.write(s);
                        }
                        Messages.get();
                        out.write(Messages.LocalCommandResults_Terminated);
                    }
                    catch (IOException e) {
                        Activator.logError("Exception while running local command", e);
                        in.close();
                        out.close();
                    }
                }
                finally {
                    in.close();
                    out.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void jobFinalize() {
                Object object = LocalCommandExecutor.this.mutex;
                synchronized (object) {
                    LocalCommandExecutor.this.processRunning = false;
                    LocalCommandExecutor.this.process = null;
                    LocalCommandExecutor.this.mutex.notifyAll();
                }
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LocalCommandExecutor.this.mutex;
                        synchronized (object) {
                            LocalCommandExecutor.this.setRunning(LocalCommandExecutor.this.processRunning);
                        }
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.processRunning) {
                this.process.destroy();
            }
        }
    }

    @Override
    protected boolean isTerminateSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.processRunning) {
                this.process.destroy();
            }
        }
        super.dispose();
    }
}

