/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.preferences;

import java.util.EnumMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.preferences.ITerminalConstants;
import org.eclipse.tm.internal.terminal.preferences.TerminalColorPresets;
import org.eclipse.tm.terminal.model.TerminalColor;

public class TerminalColorsFieldEditor
extends FieldEditor {
    private EnumMap<TerminalColor, ColorSelector> colorSelectors;
    private Composite controls;
    private Font boldFont;

    public TerminalColorsFieldEditor(Composite parent) {
        super("", "", parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.controls.getLayoutData();
        gd.horizontalSpan = numColumns;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.colorSelectors = new EnumMap(TerminalColor.class);
        this.controls = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.controls);
        GridLayoutFactory.fillDefaults().applyTo(this.controls);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1);
        this.boldFont = boldDescriptor.createFont((Device)parent.getDisplay());
        Group general = new Group(this.controls, 32);
        general.setText(TerminalMessages.TerminalColorsFieldEditor_GeneralColors);
        general.setFont(this.boldFont);
        GridDataFactory.fillDefaults().applyTo((Control)general);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)general);
        this.createLabelledSelector((Composite)general, TerminalColor.FOREGROUND, TerminalMessages.TerminalColorsFieldEditor_TextColor);
        this.createLabelledSelector((Composite)general, TerminalColor.BACKGROUND, TerminalMessages.TerminalColorsFieldEditor_Background);
        this.createLabelledSelector((Composite)general, TerminalColor.SELECTION_BACKGROUND, TerminalMessages.TerminalColorsFieldEditor_Selection);
        this.createLabelledSelector((Composite)general, TerminalColor.SELECTION_FOREGROUND, TerminalMessages.TerminalColorsFieldEditor_SelectedText);
        Group palette = new Group(this.controls, 32);
        palette.setText(TerminalMessages.TerminalColorsFieldEditor_PaletteColors);
        palette.setFont(this.boldFont);
        GridDataFactory.fillDefaults().applyTo((Control)palette);
        GridLayoutFactory.swtDefaults().numColumns(8).applyTo((Composite)palette);
        this.createSelector((Composite)palette, TerminalColor.BLACK, TerminalMessages.TerminalColorsFieldEditor_Black);
        this.createSelector((Composite)palette, TerminalColor.RED, TerminalMessages.TerminalColorsFieldEditor_Red);
        this.createSelector((Composite)palette, TerminalColor.GREEN, TerminalMessages.TerminalColorsFieldEditor_Green);
        this.createSelector((Composite)palette, TerminalColor.YELLOW, TerminalMessages.TerminalColorsFieldEditor_Yellow);
        this.createSelector((Composite)palette, TerminalColor.BLUE, TerminalMessages.TerminalColorsFieldEditor_Blue);
        this.createSelector((Composite)palette, TerminalColor.MAGENTA, TerminalMessages.TerminalColorsFieldEditor_Magenta);
        this.createSelector((Composite)palette, TerminalColor.CYAN, TerminalMessages.TerminalColorsFieldEditor_Cyan);
        this.createSelector((Composite)palette, TerminalColor.WHITE, TerminalMessages.TerminalColorsFieldEditor_White);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_BLACK, TerminalMessages.TerminalColorsFieldEditor_BrightBlack);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_RED, TerminalMessages.TerminalColorsFieldEditor_BrightRed);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_GREEN, TerminalMessages.TerminalColorsFieldEditor_BrightGreen);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_YELLOW, TerminalMessages.TerminalColorsFieldEditor_BrightYellow);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_BLUE, TerminalMessages.TerminalColorsFieldEditor_BrightBlue);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_MAGENTA, TerminalMessages.TerminalColorsFieldEditor_BrightMagenta);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_CYAN, TerminalMessages.TerminalColorsFieldEditor_BrightCyan);
        this.createSelector((Composite)palette, TerminalColor.BRIGHT_WHITE, TerminalMessages.TerminalColorsFieldEditor_BrightWhite);
        Group presets = new Group(this.controls, 32);
        presets.setText(TerminalMessages.TerminalColorsFieldEditor_Presets);
        presets.setFont(this.boldFont);
        GridDataFactory.fillDefaults().applyTo((Control)presets);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)presets);
        Combo presetsCombo = new Combo((Composite)presets, 12);
        presetsCombo.add(TerminalMessages.TerminalColorsFieldEditor_LoadPresets);
        TerminalColorPresets colorPresets = TerminalColorPresets.INSTANCE;
        colorPresets.getPresets().forEach(arg_0 -> ((Combo)presetsCombo).add(arg_0));
        presetsCombo.addListener(13, e -> {
            int selectionIndex = presetsCombo.getSelectionIndex();
            if (selectionIndex > 0) {
                int selectedPresetIndex = selectionIndex - 1;
                this.colorSelectors.forEach((terminalColor, colorSelector) -> colorSelector.setColorValue(colorPresets.getPreset(selectedPresetIndex).getRGB((TerminalColor)((Object)((Object)terminalColor)))));
            }
        });
        presetsCombo.select(0);
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }

    private void createLabelledSelector(Composite parent, TerminalColor color, String label) {
        Label labelControl = new Label(parent, 16384);
        labelControl.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelControl);
        this.createSelector(parent, color, label);
    }

    private void createSelector(Composite parent, TerminalColor color, String label) {
        ColorSelector colorSelector = new ColorSelector(parent);
        colorSelector.getButton().setToolTipText(label);
        GridDataFactory.fillDefaults().applyTo((Control)colorSelector.getButton());
        this.colorSelectors.put(color, colorSelector);
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        this.colorSelectors.forEach((terminalColor, colorSelector) -> colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)store, (String)ITerminalConstants.getPrefForTerminalColor(terminalColor))));
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        this.colorSelectors.forEach((terminalColor, colorSelector) -> colorSelector.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)ITerminalConstants.getPrefForTerminalColor(terminalColor))));
    }

    public void store() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store == null) {
            return;
        }
        if (this.presentsDefaultValue()) {
            this.doStoreDefault(store);
        } else {
            this.doStore();
        }
    }

    protected void doStoreDefault(IPreferenceStore store) {
        this.colorSelectors.forEach((terminalColor, colorSelector) -> store.setToDefault(ITerminalConstants.getPrefForTerminalColor(terminalColor)));
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        this.colorSelectors.forEach((terminalColor, colorSelector) -> PreferenceConverter.setValue((IPreferenceStore)store, (String)ITerminalConstants.getPrefForTerminalColor(terminalColor), (RGB)colorSelector.getColorValue()));
    }

    public String getPreferenceName() {
        throw new IllegalArgumentException("preference name should not be accessed as this class represent multiple preferences");
    }

    public String getLabelText() {
        throw new IllegalArgumentException("label text should not be accessed as this class represent multiple preferences");
    }
}

