/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.preferencepages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectBrowser
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor useServerFilter;
    private BooleanFieldEditor makeFullSync;
    private Composite autoApplyParent;
    private Composite delayParent;
    private Composite minLengthParent;
    private BooleanFieldEditor autoApply;
    private StringFieldEditor delay;
    private StringFieldEditor minLength;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.makeFullSync = new BooleanFieldEditor("ObjectsFullSync", "Full object synchronization on startup", this.getFieldEditorParent());
        this.addField((FieldEditor)this.makeFullSync);
        this.addField((FieldEditor)new BooleanFieldEditor("ObjectBrowser.showStatusIndicator", "Show &status indicator", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("ObjectBrowser.showFilter", "Show &filter", this.getFieldEditorParent()));
        this.useServerFilter = new BooleanFieldEditor("ObjectBrowser.useServerFilterSettings", "&Use server settings for object filter", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useServerFilter);
        this.autoApplyParent = this.getFieldEditorParent();
        this.autoApply = new BooleanFieldEditor("ObjectBrowser.filterAutoApply", "&Apply filter automatically", this.autoApplyParent);
        this.addField((FieldEditor)this.autoApply);
        this.delayParent = this.getFieldEditorParent();
        this.delay = new StringFieldEditor("ObjectBrowser.filterDelay", "Filter &delay", this.delayParent);
        this.addField((FieldEditor)this.delay);
        this.delay.setEmptyStringAllowed(false);
        this.delay.setTextLimit(5);
        this.minLengthParent = this.getFieldEditorParent();
        this.minLength = new StringFieldEditor("ObjectBrowser.filterMinLength", "Filter &minimal length", this.minLengthParent);
        this.addField((FieldEditor)this.minLength);
        this.minLength.setEmptyStringAllowed(false);
        this.minLength.setTextLimit(3);
    }

    protected void initialize() {
        super.initialize();
        boolean enabled = !this.useServerFilter.getBooleanValue();
        this.autoApply.setEnabled(enabled, this.autoApplyParent);
        this.delay.setEnabled(enabled, this.delayParent);
        this.minLength.setEnabled(enabled, this.minLengthParent);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        boolean enabled = !this.useServerFilter.getBooleanValue();
        this.autoApply.setEnabled(enabled, this.autoApplyParent);
        this.delay.setEnabled(enabled, this.delayParent);
        this.minLength.setEnabled(enabled, this.minLengthParent);
        boolean fullySync = this.makeFullSync.getBooleanValue();
        IPreferenceStore globalStore = ConsoleSharedData.getSettings();
        globalStore.setValue("ObjectsFullSync", fullySync);
        if (fullySync) {
            final NXCSession session = ConsoleSharedData.getSession();
            ConsoleJob job = new ConsoleJob("Synchronize all objects", null, "org.netxms.ui.eclipse.objectbrowser", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    if (!session.areObjectsSynchronized()) {
                        session.syncObjects();
                    }
                }

                protected String getErrorMessage() {
                    return "Failed to synchronize all objects";
                }
            };
            job.setUser(false);
            job.start();
        }
    }
}

