/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects.configs;

import org.netxms.base.NXCPMessage;

public class CustomAttribute {
    public static final long INHERITABLE = 1L;
    public static final long REDEFINED = 2L;
    protected String value;
    protected long flags;
    protected long sourceObject;

    public CustomAttribute(NXCPMessage msg, long base2) {
        this.value = msg.getFieldAsString(base2);
        this.flags = msg.getFieldAsInt32(base2 + 1L);
        this.sourceObject = msg.getFieldAsInt32(base2 + 2L);
    }

    public CustomAttribute(CustomAttribute attr) {
        this.value = attr.value;
        this.flags = attr.flags;
        this.sourceObject = attr.sourceObject;
    }

    public CustomAttribute(String value, long flags, long inheritedFrom) {
        this.value = value;
        this.flags = flags;
        this.sourceObject = inheritedFrom;
    }

    public String getValue() {
        return this.value;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getSourceObject() {
        return this.sourceObject;
    }

    public boolean isRedefined() {
        return (this.flags & 2L) > 0L;
    }

    public boolean isInherited() {
        return this.getSourceObject() != 0L;
    }

    public boolean isInheritable() {
        return (this.flags & 1L) > 0L;
    }
}

