/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SnmpVersion {
    V1(0),
    V2C(1),
    V3(3),
    DEFAULT(127);

    private static final Logger logger;
    private static final Map<Integer, SnmpVersion> lookupTable;
    private int value;

    private SnmpVersion(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SnmpVersion getByValue(int value) {
        SnmpVersion element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return V1;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(SnmpVersion.class);
        lookupTable = new HashMap<Integer, SnmpVersion>();
        for (SnmpVersion element : SnmpVersion.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

