/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBoolean$bool___or___exposer;
import org.python.core.PyBoolean$bool___pos___exposer;
import org.python.core.PyBoolean$bool___xor___exposer;
import org.python.core.PyBoolean$bool_toString_exposer;
import org.python.core.PyBoolean$exposed___new__;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyInteger;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="bool", isBaseType=false, doc="bool(x) -> bool\n\nReturns True when the argument x is true, False otherwise.\nThe builtins True and False are the only two instances of the class bool.\nThe class bool is a subclass of the class int, and cannot be subclassed.")
public class PyBoolean
extends PyInteger {
    public static final PyType TYPE;
    private final boolean value;

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public int getValue() {
        return this.getBooleanValue() ? 1 : 0;
    }

    public PyBoolean(boolean value) {
        super(TYPE, value ? 1 : 0);
        this.value = value;
    }

    @ExposedNew
    public static PyObject bool_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("bool", args, keywords, new String[]{"x"}, 0);
        PyObject obj = ap.getPyObject(0, null);
        if (obj == null) {
            return Py.False;
        }
        return obj.__nonzero__() ? Py.True : Py.False;
    }

    @Override
    public String toString() {
        return this.bool_toString();
    }

    final String bool_toString() {
        return this.getBooleanValue() ? "True" : "False";
    }

    @Override
    public int hashCode() {
        return this.bool___hash__();
    }

    final int bool___hash__() {
        return this.getBooleanValue() ? 1 : 0;
    }

    @Override
    public boolean __nonzero__() {
        return this.bool___nonzero__();
    }

    final boolean bool___nonzero__() {
        return this.getBooleanValue();
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Boolean.TYPE || c == Boolean.class || c == Object.class) {
            return this.getBooleanValue();
        }
        if (c == Integer.TYPE || c == Number.class || c == Integer.class) {
            return this.getValue();
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return (byte)this.getValue();
        }
        if (c == Short.TYPE || c == Short.class) {
            return (short)this.getValue();
        }
        if (c == Long.TYPE || c == Long.class) {
            return (long)this.getValue();
        }
        if (c == Float.TYPE || c == Float.class) {
            return Float.valueOf(this.getValue());
        }
        if (c == Double.TYPE || c == Double.class) {
            return (double)this.getValue();
        }
        return super.__tojava__(c);
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.bool___and__(right);
    }

    final PyObject bool___and__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() & ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() & ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.bool___xor__(right);
    }

    final PyObject bool___xor__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() ^ ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() ^ ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.bool___or__(right);
    }

    final PyObject bool___or__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() | ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() | ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __neg__() {
        return this.bool___neg__();
    }

    final PyObject bool___neg__() {
        return Py.newInteger(this.getBooleanValue() ? -1 : 0);
    }

    @Override
    public PyObject __pos__() {
        return this.bool___pos__();
    }

    final PyObject bool___pos__() {
        return Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __abs__() {
        return this.bool___abs__();
    }

    final PyObject bool___abs__() {
        return Py.newInteger(this.getValue());
    }

    static {
        PyType.addBuilder(PyBoolean.class, new PyBoolean$PyExposer());
        TYPE = PyType.fromClass(PyBoolean.class);
    }

    public class PyBoolean$bool___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyBoolean$bool___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBoolean$bool___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBoolean$bool___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyBoolean)this.self).bool___hash__());
        }
    }

    public class PyBoolean$bool___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyBoolean$bool___nonzero___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyBoolean$bool___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBoolean$bool___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyBoolean)this.self).bool___nonzero__());
        }
    }

    public class PyBoolean$bool___and___exposer
    extends PyBuiltinMethodNarrow {
        public PyBoolean$bool___and___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__and__(y) <==> x&y";
        }

        public PyBoolean$bool___and___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__and__(y) <==> x&y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBoolean$bool___and___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyBoolean)this.self).bool___and__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyBoolean$bool___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyBoolean$bool___neg___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyBoolean$bool___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBoolean$bool___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyBoolean)this.self).bool___neg__();
        }
    }

    public class PyBoolean$bool___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyBoolean$bool___abs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyBoolean$bool___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBoolean$bool___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyBoolean)this.self).bool___abs__();
        }
    }

    public class PyBoolean$PyExposer
    extends BaseTypeBuilder {
        public PyBoolean$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyBoolean$bool_toString_exposer("__str__"), new PyBoolean$bool_toString_exposer("__repr__"), new PyBoolean$bool___hash___exposer("__hash__"), new PyBoolean$bool___nonzero___exposer("__nonzero__"), new PyBoolean$bool___and___exposer("__and__"), new PyBoolean$bool___xor___exposer("__xor__"), new PyBoolean$bool___or___exposer("__or__"), new PyBoolean$bool___neg___exposer("__neg__"), new PyBoolean$bool___pos___exposer("__pos__"), new PyBoolean$bool___abs___exposer("__abs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("bool", PyBoolean.class, Object.class, false, "bool(x) -> bool\n\nReturns True when the argument x is true, False otherwise.\nThe builtins True and False are the only two instances of the class bool.\nThe class bool is a subclass of the class int, and cannot be subclassed.", pyBuiltinMethodArray, pyDataDescrArray, new PyBoolean$exposed___new__());
        }
    }
}

