/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.annotations.GwtIncompatible;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractMultiset;
import org.python.google.common.collect.AbstractObjectCountMap;
import org.python.google.common.collect.CollectPreconditions;
import org.python.google.common.collect.Multiset;
import org.python.google.common.primitives.Ints;
import org.python.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    transient AbstractObjectCountMap<E> backingMap;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = -2250766705698539974L;

    protected AbstractMapBasedMultiset(AbstractObjectCountMap<E> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
        this.size = super.size();
    }

    void setBackingMap(AbstractObjectCountMap<E> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    Set<E> createElementSet() {
        return this.backingMap.keySet();
    }

    @Override
    public Set<Multiset.Entry<E>> createEntrySet() {
        return new AbstractMultiset.EntrySet();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final Iterator<Multiset.Entry<E>> backingEntries = this.backingMap.entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>(){
            Multiset.Entry<E> toRemove;
            boolean canRemove;

            @Override
            public boolean hasNext() {
                return backingEntries.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                Multiset.Entry mapEntry;
                this.toRemove = mapEntry = (Multiset.Entry)backingEntries.next();
                this.canRemove = true;
                return mapEntry;
            }

            @Override
            public void remove() {
                CollectPreconditions.checkRemove(this.canRemove);
                AbstractMapBasedMultiset.this.size = AbstractMapBasedMultiset.this.size - (long)this.toRemove.getCount();
                backingEntries.remove();
                this.canRemove = false;
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator();
    }

    @Override
    public int count(@Nullable Object element) {
        return this.backingMap.get(element);
    }

    @Override
    @CanIgnoreReturnValue
    public int add(@Nullable E element, int occurrences) {
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        int oldCount = this.backingMap.get(element);
        long newCount = (long)oldCount + (long)occurrences;
        Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
        this.backingMap.put(element, (int)newCount);
        this.size += (long)occurrences;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@Nullable Object element, int occurrences) {
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        int oldCount = this.backingMap.get(element);
        if (oldCount > occurrences) {
            numberRemoved = occurrences;
            this.backingMap.put(element, oldCount - occurrences);
        } else {
            numberRemoved = oldCount;
            this.backingMap.remove(element);
        }
        this.size -= (long)numberRemoved;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(@Nullable E element, int count2) {
        CollectPreconditions.checkNonnegative(count2, "count");
        int oldCount = count2 == 0 ? this.backingMap.remove(element) : this.backingMap.put(element, count2);
        this.size += (long)(count2 - oldCount);
        return oldCount;
    }

    @GwtIncompatible
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    private class MapBasedMultisetIterator
    implements Iterator<E> {
        final Iterator<Multiset.Entry<E>> entryIterator;
        Multiset.Entry<E> currentEntry;
        int occurrencesLeft = 0;
        boolean canRemove = false;

        MapBasedMultisetIterator() {
            this.entryIterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                this.occurrencesLeft = this.currentEntry.getCount();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            int frequency = this.currentEntry.getCount();
            if (frequency <= 0) {
                throw new ConcurrentModificationException();
            }
            if (frequency == 1) {
                this.entryIterator.remove();
            } else {
                ((AbstractObjectCountMap.MapEntry)this.currentEntry).setCount(frequency - 1);
            }
            AbstractMapBasedMultiset.this.size--;
            this.canRemove = false;
        }
    }
}

