/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._csv;

import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.modules._csv.PyDialect;
import org.python.modules._csv.PyReader$dialect_descriptor;
import org.python.modules._csv.QuoteStyle;
import org.python.modules._csv._csv;

@ExposedType(name="_csv.reader", doc="CSV reader\n\nReader objects are responsible for reading and parsing tabular data\nin CSV format.\n")
public class PyReader
extends PyIterator {
    public static final PyType TYPE;
    public static final String reader_doc = "CSV reader\n\nReader objects are responsible for reading and parsing tabular data\nin CSV format.\n";
    public PyDialect dialect;
    public int line_num = 0;
    private PyObject input_iter;
    private ParserState state = ParserState.START_RECORD;
    private PyList fields = new PyList();
    private StringBuffer field = new StringBuffer(4096);
    private boolean numeric_field = false;
    private static final int INITIAL_BUILDER_CAPACITY = 4096;

    public PyReader(PyObject input_iter, PyDialect dialect) {
        this.input_iter = input_iter;
        this.dialect = dialect;
    }

    @Override
    public PyObject __iternext__() {
        this.parse_reset();
        do {
            PyObject lineobj;
            if ((lineobj = this.input_iter.__iternext__()) == null) {
                if (this.field.length() != 0 || this.state == ParserState.IN_QUOTED_FIELD) {
                    if (this.dialect.strict) {
                        throw _csv.Error("unexpected end of data");
                    }
                    this.parse_save_field();
                    break;
                }
                return null;
            }
            ++this.line_num;
            String line = lineobj.toString();
            int linelen = line.length();
            for (int i = 0; i < linelen; ++i) {
                char c = line.charAt(i);
                if (c == '\u0000') {
                    throw _csv.Error("line contains NULL byte");
                }
                this.parse_process_char(c);
            }
            this.parse_process_char('\u0000');
        } while (this.state != ParserState.START_RECORD);
        PyList fields = this.fields;
        this.fields = new PyList();
        return fields;
    }

    private void parse_process_char(char c) {
        switch (this.state) {
            case START_RECORD: {
                if (c == '\u0000') break;
                if (c == '\n' || c == '\r') {
                    this.state = ParserState.EAT_CRNL;
                    break;
                }
                this.state = ParserState.START_FIELD;
            }
            case START_FIELD: {
                if (c == '\n' || c == '\r' || c == '\u0000') {
                    this.parse_save_field();
                    this.state = c == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (c == this.dialect.quotechar && this.dialect.quoting != QuoteStyle.QUOTE_NONE) {
                    this.state = ParserState.IN_QUOTED_FIELD;
                    break;
                }
                if (c == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPED_CHAR;
                    break;
                }
                if (c == ' ' && this.dialect.skipinitialspace) break;
                if (c == this.dialect.delimiter) {
                    this.parse_save_field();
                    break;
                }
                if (this.dialect.quoting == QuoteStyle.QUOTE_NONNUMERIC) {
                    this.numeric_field = true;
                }
                this.parse_add_char(c);
                this.state = ParserState.IN_FIELD;
                break;
            }
            case ESCAPED_CHAR: {
                if (c == '\u0000') {
                    c = (char)10;
                }
                this.parse_add_char(c);
                this.state = ParserState.IN_FIELD;
                break;
            }
            case IN_FIELD: {
                if (c == '\n' || c == '\r' || c == '\u0000') {
                    this.parse_save_field();
                    this.state = c == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (c == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPED_CHAR;
                    break;
                }
                if (c == this.dialect.delimiter) {
                    this.parse_save_field();
                    this.state = ParserState.START_FIELD;
                    break;
                }
                this.parse_add_char(c);
                break;
            }
            case IN_QUOTED_FIELD: {
                if (c == '\u0000') break;
                if (c == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPE_IN_QUOTED_FIELD;
                    break;
                }
                if (c == this.dialect.quotechar && this.dialect.quoting != QuoteStyle.QUOTE_NONE) {
                    if (this.dialect.doublequote) {
                        this.state = ParserState.QUOTE_IN_QUOTED_FIELD;
                        break;
                    }
                    this.state = ParserState.IN_FIELD;
                    break;
                }
                this.parse_add_char(c);
                break;
            }
            case ESCAPE_IN_QUOTED_FIELD: {
                if (c == '\u0000') {
                    c = (char)10;
                }
                this.parse_add_char(c);
                this.state = ParserState.IN_QUOTED_FIELD;
                break;
            }
            case QUOTE_IN_QUOTED_FIELD: {
                if (this.dialect.quoting != QuoteStyle.QUOTE_NONE && c == this.dialect.quotechar) {
                    this.parse_add_char(c);
                    this.state = ParserState.IN_QUOTED_FIELD;
                    break;
                }
                if (c == this.dialect.delimiter) {
                    this.parse_save_field();
                    this.state = ParserState.START_FIELD;
                    break;
                }
                if (c == '\n' || c == '\r' || c == '\u0000') {
                    this.parse_save_field();
                    this.state = c == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (!this.dialect.strict) {
                    this.parse_add_char(c);
                    this.state = ParserState.IN_FIELD;
                    break;
                }
                throw _csv.Error(String.format("'%c' expected after '%c'", Character.valueOf(this.dialect.delimiter), Character.valueOf(this.dialect.quotechar)));
            }
            case EAT_CRNL: {
                if (c == '\n' || c == '\r') break;
                if (c == '\u0000') {
                    this.state = ParserState.START_RECORD;
                    break;
                }
                String err = "new-line character seen in unquoted field - do you need to open the file in universal-newline mode?";
                throw _csv.Error(err);
            }
        }
    }

    private void parse_reset() {
        this.fields = new PyList();
        this.state = ParserState.START_RECORD;
        this.numeric_field = false;
    }

    private void parse_save_field() {
        PyObject field = new PyString(this.field.toString());
        if (this.numeric_field) {
            this.numeric_field = false;
            field = ((PyObject)field).__float__();
        }
        this.fields.append(field);
        this.field = new StringBuffer(4096);
    }

    private void parse_add_char(char c) {
        int field_len = this.field.length();
        if (field_len >= _csv.field_limit) {
            throw _csv.Error(String.format("field larger than field limit (%d)", _csv.field_limit));
        }
        this.field.append(c);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        if (this.dialect != null && (retVal = visit.visit(this.dialect, arg)) != 0) {
            return retVal;
        }
        if (this.input_iter != null && (retVal = visit.visit(this.input_iter, arg)) != 0) {
            return retVal;
        }
        return this.fields != null ? visit.visit(this.fields, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob == null && (ob == this.fields || ob == this.dialect || ob == this.input_iter || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(PyReader.class, new PyReader$PyExposer());
        TYPE = PyType.fromClass(PyReader.class);
    }

    private static enum ParserState {
        START_RECORD,
        START_FIELD,
        ESCAPED_CHAR,
        IN_FIELD,
        IN_QUOTED_FIELD,
        ESCAPE_IN_QUOTED_FIELD,
        QUOTE_IN_QUOTED_FIELD,
        EAT_CRNL;

    }

    public class PyReader$line_num_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyReader$line_num_descriptor() {
            super("line_num", Integer.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PyReader)pyObject).line_num);
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyReader$PyExposer
    extends BaseTypeBuilder {
        public PyReader$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyReader$dialect_descriptor(), new PyReader$line_num_descriptor()};
            super("_csv.reader", PyReader.class, Object.class, true, "CSV reader\n\nReader objects are responsible for reading and parsing tabular data\nin CSV format.\n", pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

