/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.certificate.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import org.netxms.certificate.loader.KeyStoreLoader;
import org.netxms.certificate.loader.KeyStoreRequestListener;
import org.netxms.certificate.loader.exception.KeyStoreLoaderException;

public class PKCS12KeyStoreLoader
implements KeyStoreLoader {
    private KeyStoreRequestListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore loadKeyStore() throws KeyStoreLoaderException {
        if (this.listener == null) {
            throw new KeyStoreLoaderException("KeyStoreRequestListener not set!");
        }
        KeyStore ks = KeyStore.getInstance("PKCS12");
        String ksLocation = this.listener.keyStoreLocationRequested();
        if (ksLocation == null) {
            return null;
        }
        FileInputStream fis = new FileInputStream(ksLocation);
        try {
            ks.load(fis, new char[0]);
        }
        catch (IOException ioe) {
            fis.close();
            fis = new FileInputStream(ksLocation);
            String keyStorePassword = this.listener.keyStorePasswordRequested();
            if (keyStorePassword == null || keyStorePassword.isEmpty()) {
                KeyStore keyStore = null;
                fis.close();
                return keyStore;
            }
            try {
                try {
                    ks.load(fis, keyStorePassword.toCharArray());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    fis.close();
                }
            }
            catch (Exception e) {
                throw new KeyStoreLoaderException(e.getMessage());
            }
        }
        return ks;
    }

    @Override
    public void setKeyStoreRequestListener(KeyStoreRequestListener listener) {
        this.listener = listener;
    }
}

