/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.BulkDciUpdateElement;
import org.netxms.client.datacollection.DCOStatusHolder;
import org.netxms.client.datacollection.DataCollectionConfigurationChangeListener;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;

public class DataCollectionConfiguration {
    private NXCSession session;
    private long ownerId;
    private HashMap<Long, DataCollectionObject> items;
    private Object userData = null;
    private SessionListener listener;
    private DataCollectionConfigurationChangeListener changeListener;

    public DataCollectionConfiguration(NXCSession session, long ownerId) {
        this.session = session;
        this.ownerId = ownerId;
        this.items = new HashMap(0);
    }

    public void open(DataCollectionConfigurationChangeListener changeListener) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.session.newMessage(41);
        msg.setFieldInt32(3L, (int)this.ownerId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.changeListener = changeListener;
        while (!(response = this.session.waitForMessage(42, msg.getMessageId())).isEndOfSequence()) {
            DataCollectionObject dco;
            int type = response.getFieldAsInt32(411L);
            switch (type) {
                case 1: {
                    dco = new DataCollectionItem(this, response);
                    break;
                }
                case 2: {
                    dco = new DataCollectionTable(this, response);
                    break;
                }
                default: {
                    dco = null;
                }
            }
            if (dco == null) continue;
            this.items.put(dco.getId(), dco);
        }
        this.listener = new SessionListener(){

            @Override
            public void notificationHandler(SessionNotification n) {
                if (n.getSubCode() != DataCollectionConfiguration.this.ownerId) {
                    return;
                }
                if (n.getCode() == 1035) {
                    DataCollectionObject dco = (DataCollectionObject)n.getObject();
                    DataCollectionConfiguration.this.items.put(dco.getId(), dco instanceof DataCollectionItem ? new DataCollectionItem(DataCollectionConfiguration.this, (DataCollectionItem)dco) : new DataCollectionTable(DataCollectionConfiguration.this, (DataCollectionTable)dco));
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        DataCollectionConfiguration.this.changeListener.onUpdate(dco);
                    }
                } else if (n.getCode() == 1036) {
                    long id = (Long)n.getObject();
                    DataCollectionConfiguration.this.items.remove(id);
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        DataCollectionConfiguration.this.changeListener.onDelete(id);
                    }
                } else if (n.getCode() == 1037) {
                    DCOStatusHolder stHolder = (DCOStatusHolder)n.getObject();
                    DataCollectionConfiguration.this.updateItemStatusFromNotification(stHolder.getDciIdArray(), stHolder.getStatus());
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        for (long id : stHolder.getDciIdArray()) {
                            DataCollectionConfiguration.this.changeListener.onStatusChange(id, stHolder.getStatus());
                        }
                    }
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void refreshDataCollectionList() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.session.newMessage(41);
        msg.setFieldInt32(3L, (int)this.ownerId);
        msg.setField(668L, true);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.clear();
        while (!(response = this.session.waitForMessage(42, msg.getMessageId())).isEndOfSequence()) {
            DataCollectionObject dco;
            int type = response.getFieldAsInt32(411L);
            switch (type) {
                case 1: {
                    dco = new DataCollectionItem(this, response);
                    break;
                }
                case 2: {
                    dco = new DataCollectionTable(this, response);
                    break;
                }
                default: {
                    dco = null;
                }
            }
            if (dco == null) continue;
            this.items.put(dco.getId(), dco);
        }
    }

    public void close() throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(46);
        msg.setFieldInt32(3L, (int)this.ownerId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.clear();
        this.session.removeListener(this.listener);
        this.changeListener = null;
    }

    public DataCollectionObject[] getItems() {
        return this.items.values().toArray(new DataCollectionObject[this.items.size()]);
    }

    public DataCollectionObject findItem(long id) {
        return this.items.get(id);
    }

    private void updateItemStatusFromNotification(long[] idList, int status) {
        for (int i = 0; i < idList.length; ++i) {
            DataCollectionObject o = this.items.get(idList[i]);
            if (o == null) continue;
            o.setStatus(status);
        }
    }

    public DataCollectionObject findItem(long id, Class<? extends DataCollectionObject> classFilter) {
        DataCollectionObject o = this.items.get(id);
        if (o == null) {
            return null;
        }
        return classFilter.isInstance(o) ? o : null;
    }

    @Deprecated
    public long createItem(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionItem(this, 0L));
    }

    @Deprecated
    public long createTable(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionTable(this, 0L));
    }

    public void modifyObject(long dcObjectId) throws IOException, NXCException {
        DataCollectionObject dco = this.items.get(dcObjectId);
        if (dco == null) {
            throw new NXCException(14);
        }
        this.modifyObject(dco);
    }

    public long modifyObject(DataCollectionObject dco) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(45);
        msg.setFieldInt32(3L, (int)this.ownerId);
        if (dco != null) {
            dco.fillMessage(msg);
        }
        this.session.sendMessage(msg);
        return this.session.waitForRCC(msg.getMessageId()).getFieldAsInt64(43L);
    }

    private void copyObjectsInternal(long destNodeId, long[] items, boolean move) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(91);
        msg.setFieldInt32(109L, (int)this.ownerId);
        msg.setFieldInt32(110L, (int)destNodeId);
        msg.setFieldInt16(220L, move ? 1 : 0);
        msg.setFieldInt32(111L, items.length);
        msg.setField(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void copyObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, false);
    }

    public void moveObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, true);
    }

    public void clearCollectedData(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(228);
        msg.setFieldInt32(3L, (int)this.ownerId);
        msg.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void setObjectStatus(long[] items, int status) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(104);
        msg.setFieldInt32(3L, (int)this.ownerId);
        msg.setFieldInt16(48L, status);
        msg.setFieldInt32(111L, items.length);
        msg.setField(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void deleteObject(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(44);
        msg.setFieldInt32(3L, (int)this.ownerId);
        msg.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.remove(itemId);
    }

    public void bulkUpdateDCIs(Collection<Long> idList, Collection<? extends BulkDciUpdateElement> fields) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(420);
        msg.setFieldInt32(3L, (int)this.ownerId);
        for (BulkDciUpdateElement bulkDciUpdateElement : fields) {
            bulkDciUpdateElement.setField(msg);
        }
        msg.setField(112L, idList);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    protected final NXCSession getSession() {
        return this.session;
    }
}

