/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.JavaIterator;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyXRange$exposed___new__;
import org.python.core.PyXRange$xrange___getitem___exposer;
import org.python.core.PyXRange$xrange___reduce___exposer;
import org.python.core.PyXRange$xrange___reversed___exposer;
import org.python.core.PyXRangeIter;
import org.python.core.Untraversable;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="xrange", base=PyObject.class, isBaseType=false, doc="xrange([start,] stop[, step]) -> xrange object\n\nLike range(), but instead of returning a list, returns an object that\ngenerates the numbers in the range on demand.  For looping, this is \nslightly faster than range() and more memory efficient.")
public class PyXRange
extends PySequence {
    public static final PyType TYPE;
    private final long start;
    private final long step;
    private final long stop;
    private final long len;

    public PyXRange(int ihigh) {
        this(0, ihigh, 1);
    }

    public PyXRange(int ilow, int ihigh) {
        this(ilow, ihigh, 1);
    }

    public PyXRange(int ilow, int ihigh, int istep) {
        super(TYPE);
        if (istep == 0) {
            throw Py.ValueError("xrange() arg 3 must not be zero");
        }
        long listep = istep;
        int n = listep > 0L ? PyXRange.getLenOfRange(ilow, ihigh, listep) : PyXRange.getLenOfRange(ihigh, ilow, -listep);
        if (n < 0) {
            throw Py.OverflowError("xrange() result has too many items");
        }
        this.start = ilow;
        this.len = n;
        this.step = istep;
        this.stop = ihigh;
    }

    @ExposedNew
    static final PyObject xrange___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int ihigh;
        ArgParser ap = new ArgParser("xrange", args, keywords, new String[]{"ilow", "ihigh", "istep"}, 1);
        ap.noKeywords();
        int ilow = 0;
        int istep = 1;
        if (args.length == 1) {
            ihigh = ap.getInt(0);
        } else {
            ilow = ap.getInt(0);
            ihigh = ap.getInt(1);
            istep = ap.getInt(2, 1);
        }
        return new PyXRange(ilow, ihigh, istep);
    }

    static int getLenOfRange(long lo, long hi, long step) {
        if (lo < hi) {
            long diff = hi - lo - 1L;
            return (int)(diff / step + 1L);
        }
        return 0;
    }

    @Override
    public int __len__() {
        return this.xrange___len__();
    }

    final int xrange___len__() {
        return (int)this.len;
    }

    @Override
    public PyObject __getitem__(PyObject index) {
        return this.xrange___getitem__(index);
    }

    final PyObject xrange___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("xrange object index out of range");
        }
        return ret;
    }

    @Override
    public PyObject __iter__() {
        return this.xrange___iter__();
    }

    public PyObject xrange___iter__() {
        return this.range_iter();
    }

    public PyObject xrange___reversed__() {
        return this.range_reverse();
    }

    private final PyXRangeIter range_iter() {
        return new PyXRangeIter(0L, this.start, this.step, this.len);
    }

    private final PyXRangeIter range_reverse() {
        return new PyXRangeIter(0L, this.start + (this.len - 1L) * this.step, 0L - this.step, this.len);
    }

    public PyObject xrange___reduce__() {
        return new PyTuple(this.getType(), new PyTuple(Py.newInteger(this.start), Py.newInteger(this.stop), Py.newInteger(this.step)));
    }

    @Override
    public PyObject __reduce__() {
        return this.xrange___reduce__();
    }

    @Override
    protected PyObject pyget(int i) {
        return Py.newInteger(this.start + (long)i % this.len * this.step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        throw Py.TypeError("xrange index must be integer, not 'slice'");
    }

    @Override
    protected PyObject repeat(int howmany) {
        return null;
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        return null;
    }

    @Override
    public String toString() {
        long lstop = this.start + this.len * this.step;
        if (lstop > Integer.MAX_VALUE) {
            lstop = Integer.MAX_VALUE;
        } else if (lstop < Integer.MIN_VALUE) {
            lstop = Integer.MIN_VALUE;
        }
        int stop = (int)lstop;
        if (this.start == 0L && this.step == 1L) {
            return String.format("xrange(%d)", stop);
        }
        if (this.step == 1L) {
            return String.format("xrange(%d, %d)", this.start, stop);
        }
        return String.format("xrange(%d, %d, %d)", this.start, stop, this.step);
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c.isAssignableFrom(Iterable.class)) {
            return new JavaIterator(this.range_iter());
        }
        if (c.isAssignableFrom(Iterator.class)) {
            return new JavaIterator(this.range_iter()).iterator();
        }
        if (c.isAssignableFrom(Collection.class)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object obj : new JavaIterator(this.range_iter())) {
                list.add(obj);
            }
            return list;
        }
        if (c.isArray()) {
            PyArray array = new PyArray(c.getComponentType(), this);
            return array.__tojava__(c);
        }
        return super.__tojava__(c);
    }

    static {
        PyType.addBuilder(PyXRange.class, new PyXRange$PyExposer());
        TYPE = PyType.fromClass(PyXRange.class);
    }

    public class PyXRange$xrange___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyXRange$xrange___len___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyXRange$xrange___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyXRange$xrange___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyXRange)this.self).xrange___len__());
        }
    }

    public class PyXRange$xrange___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyXRange$xrange___iter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyXRange$xrange___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyXRange$xrange___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyXRange)this.self).xrange___iter__();
        }
    }

    public class PyXRange$PyExposer
    extends BaseTypeBuilder {
        public PyXRange$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyXRange$xrange___len___exposer("__len__"), new PyXRange$xrange___getitem___exposer("__getitem__"), new PyXRange$xrange___iter___exposer("__iter__"), new PyXRange$xrange___reversed___exposer("__reversed__"), new PyXRange$xrange___reduce___exposer("__reduce__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("xrange", PyXRange.class, PyObject.class, false, "xrange([start,] stop[, step]) -> xrange object\n\nLike range(), but instead of returning a list, returns an object that\ngenerates the numbers in the range on demand.  For looping, this is \nslightly faster than range() and more memory efficient.", pyBuiltinMethodArray, pyDataDescrArray, new PyXRange$exposed___new__());
        }
    }
}

