/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.constants.ColumnFilterType;

public class ColumnFilter {
    private ColumnFilterType type;
    private long rangeFrom;
    private long rangeTo;
    private long numericValue;
    private String like;
    private HashSet<ColumnFilter> set;
    private ColumnFilterSetOperation operation;
    private boolean negated = false;

    public ColumnFilter(ColumnFilterType type, long value) {
        this.type = type;
        this.numericValue = value;
    }

    public ColumnFilter(long rangeFrom, long rangeTo) {
        this.type = ColumnFilterType.RANGE;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
    }

    public ColumnFilter(String value) {
        this.type = ColumnFilterType.LIKE;
        this.like = value;
    }

    public ColumnFilter() {
        this.type = ColumnFilterType.SET;
        this.set = new HashSet();
        this.operation = ColumnFilterSetOperation.AND;
    }

    public void addSubFilter(ColumnFilter filter) {
        if (this.type == ColumnFilterType.SET) {
            this.set.add(filter);
        }
    }

    int fillMessage(NXCPMessage msg, long baseId) {
        int varCount = 1;
        msg.setFieldInt16(baseId, this.type.getValue());
        switch (this.type) {
            case EQUALS: 
            case LESS: 
            case GREATER: 
            case CHILDOF: {
                msg.setFieldInt64(baseId + 1L, this.numericValue);
                msg.setFieldInt16(baseId + 2L, this.negated ? 1 : 0);
                varCount += 2;
                break;
            }
            case RANGE: {
                msg.setFieldInt64(baseId + 1L, this.rangeFrom);
                msg.setFieldInt64(baseId + 2L, this.rangeTo);
                msg.setFieldInt16(baseId + 3L, this.negated ? 1 : 0);
                varCount += 3;
                break;
            }
            case LIKE: {
                msg.setField(baseId + 1L, this.like);
                msg.setFieldInt16(baseId + 2L, this.negated ? 1 : 0);
                varCount += 2;
                break;
            }
            case SET: {
                msg.setFieldInt16(baseId + 1L, this.operation.getValue());
                msg.setFieldInt16(baseId + 2L, this.set.size());
                varCount += 2;
                long varId = baseId + 3L;
                for (ColumnFilter f : this.set) {
                    int count2 = f.fillMessage(msg, varId);
                    varId += (long)count2;
                    varCount += count2;
                }
                break;
            }
        }
        return varCount;
    }

    public long getRangeFrom() {
        return this.rangeFrom;
    }

    public void setRangeFrom(long rangeFrom) {
        this.rangeFrom = rangeFrom;
    }

    public long getRangeTo() {
        return this.rangeTo;
    }

    public void setRangeTo(long rangeTo) {
        this.rangeTo = rangeTo;
    }

    public long getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(long numericValue) {
        this.numericValue = numericValue;
    }

    public String getLike() {
        return this.like;
    }

    public void setLike(String like) {
        this.like = like;
    }

    public ColumnFilterSetOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ColumnFilterSetOperation operation) {
        this.operation = operation;
    }

    public ColumnFilterType getType() {
        return this.type;
    }

    public Set<ColumnFilter> getSubFilters() {
        return this.set;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }
}

