/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.stringlib.MarkupIterator$formatteriterator___iter___exposer;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="formatteriterator", base=PyObject.class, isBaseType=false)
public class MarkupIterator
extends PyObject {
    public static final PyType TYPE;
    private final String markup;
    private final boolean bytes;
    private int index;
    private final FieldNumbering numbering;

    public MarkupIterator(PyString markupObject) {
        this.markup = markupObject.getString();
        this.bytes = !(markupObject instanceof PyUnicode);
        this.numbering = new FieldNumbering();
    }

    public MarkupIterator(MarkupIterator enclosingIterator, String subMarkup) {
        this.markup = subMarkup;
        this.bytes = enclosingIterator.bytes;
        this.numbering = enclosingIterator.numbering;
    }

    @Override
    public PyObject __iter__() {
        return this.formatteriterator___iter__();
    }

    final PyObject formatteriterator___iter__() {
        return this;
    }

    @Override
    public PyObject __iternext__() {
        return this.formatteriterator___iternext__();
    }

    final PyObject formatteriterator___iternext__() {
        try {
            Chunk chunk2 = this.nextChunk();
            if (chunk2 != null) {
                PyObject[] elements = new PyObject[4];
                elements[0] = this.wrap(chunk2.literalText, "");
                if (chunk2.fieldName == null) {
                    for (int i = 1; i < elements.length; ++i) {
                        elements[i] = Py.None;
                    }
                } else {
                    elements[1] = this.wrap(chunk2.fieldName, "");
                    elements[2] = this.wrap(chunk2.formatSpec, "");
                    elements[3] = this.wrap(chunk2.conversion, null);
                }
                return new PyTuple(elements);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
    }

    private PyObject wrap(String value, String defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return Py.None;
        }
        if (value.length() == 0) {
            return this.bytes ? Py.EmptyString : Py.EmptyUnicode;
        }
        return this.bytes ? Py.newString(value) : Py.newUnicode(value);
    }

    public Chunk nextChunk() {
        if (this.index == this.markup.length()) {
            return null;
        }
        Chunk result2 = new Chunk();
        int pos = this.index;
        while ((pos = this.indexOfFirst(this.markup, pos, '{', '}')) >= 0 && pos < this.markup.length() - 1 && this.markup.charAt(pos + 1) == this.markup.charAt(pos)) {
            pos += 2;
        }
        if (pos >= 0 && this.markup.charAt(pos) == '}') {
            throw new IllegalArgumentException("Single '}' encountered in format string");
        }
        if (pos < 0) {
            result2.literalText = this.unescapeBraces(this.markup.substring(this.index));
            this.index = this.markup.length();
        } else {
            result2.literalText = this.unescapeBraces(this.markup.substring(this.index, pos));
            int fieldStart = ++pos;
            int count2 = 1;
            while (pos < this.markup.length()) {
                if (this.markup.charAt(pos) == '{') {
                    ++count2;
                    result2.formatSpecNeedsExpanding = true;
                } else if (this.markup.charAt(pos) == '}' && --count2 == 0) {
                    this.parseField(result2, this.markup.substring(fieldStart, pos));
                    ++pos;
                    break;
                }
                ++pos;
            }
            if (count2 > 0) {
                throw new IllegalArgumentException("Single '{' encountered in format string");
            }
            this.index = pos;
        }
        return result2;
    }

    public final boolean isBytes() {
        return this.bytes;
    }

    private String unescapeBraces(String substring) {
        return substring.replace("{{", "{").replace("}}", "}");
    }

    private void parseField(Chunk result2, String fieldMarkup) {
        int pos = this.indexOfFirst(fieldMarkup, 0, '!', ':');
        if (pos >= 0) {
            result2.fieldName = fieldMarkup.substring(0, pos);
            if (fieldMarkup.charAt(pos) == '!') {
                if (pos == fieldMarkup.length() - 1) {
                    throw new IllegalArgumentException("end of format while looking for conversion specifier");
                }
                result2.conversion = fieldMarkup.substring(pos + 1, pos + 2);
                if ((pos += 2) < fieldMarkup.length()) {
                    if (fieldMarkup.charAt(pos) != ':') {
                        throw new IllegalArgumentException("expected ':' after conversion specifier");
                    }
                    result2.formatSpec = fieldMarkup.substring(pos + 1);
                }
            } else {
                result2.formatSpec = fieldMarkup.substring(pos + 1);
            }
        } else {
            result2.fieldName = fieldMarkup;
        }
        if (result2.fieldName.isEmpty()) {
            result2.fieldName = this.numbering.nextAutomaticFieldNumber();
            return;
        }
        char c = result2.fieldName.charAt(0);
        if (c == '.' || c == '[') {
            result2.fieldName = this.numbering.nextAutomaticFieldNumber() + result2.fieldName;
            return;
        }
        if (Character.isDigit(c)) {
            this.numbering.useManualFieldNumbering();
        }
    }

    private int indexOfFirst(String s, int start, char c1, char c2) {
        int i1 = s.indexOf(c1, start);
        int i2 = s.indexOf(c2, start);
        if (i1 == -1) {
            return i2;
        }
        if (i2 == -1) {
            return i1;
        }
        return Math.min(i1, i2);
    }

    static {
        PyType.addBuilder(MarkupIterator.class, new MarkupIterator$PyExposer());
        TYPE = PyType.fromClass(MarkupIterator.class);
    }

    public static final class Chunk {
        public String literalText;
        public String fieldName;
        public String formatSpec;
        public String conversion;
        public boolean formatSpecNeedsExpanding;
    }

    static final class FieldNumbering {
        private boolean manualFieldNumberSpecified;
        private int automaticFieldNumber = 0;

        FieldNumbering() {
        }

        String nextAutomaticFieldNumber() {
            if (this.manualFieldNumberSpecified) {
                throw new IllegalArgumentException("cannot switch from manual field specification to automatic field numbering");
            }
            return Integer.toString(this.automaticFieldNumber++);
        }

        void useManualFieldNumbering() {
            if (this.manualFieldNumberSpecified) {
                return;
            }
            if (this.automaticFieldNumber != 0) {
                throw new IllegalArgumentException("cannot switch from automatic field numbering to manual field specification");
            }
            this.manualFieldNumberSpecified = true;
        }
    }

    public class MarkupIterator$formatteriterator___iternext___exposer
    extends PyBuiltinMethodNarrow {
        public MarkupIterator$formatteriterator___iternext___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public MarkupIterator$formatteriterator___iternext___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new MarkupIterator$formatteriterator___iternext___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((MarkupIterator)this.self).formatteriterator___iternext__();
        }
    }

    public class MarkupIterator$PyExposer
    extends BaseTypeBuilder {
        public MarkupIterator$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new MarkupIterator$formatteriterator___iter___exposer("__iter__"), new MarkupIterator$formatteriterator___iternext___exposer("__iternext__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("formatteriterator", MarkupIterator.class, PyObject.class, false, null, pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

