/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;

public class DataCollectionConfigurationHandler
extends AbstractObjectHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        DataCollectionConfiguration dc = this.getSession().openDataCollectionConfiguration(this.getObjectId());
        List<DataCollectionObject> dcObjects = Arrays.asList(dc.getItems());
        dc.close();
        return new ResponseContainer("dataCollectionObjects", dcObjects);
    }

    protected Object create(JSONObject data) throws Exception {
        DataCollectionObject dcObject = (DataCollectionObject)JsonTools.createGsonInstance().fromJson(data.toString(), DataCollectionObject.class);
        if (dcObject.getName() == null || dcObject.getName().isEmpty() || dcObject.getDescription() == null || dcObject.getDescription().isEmpty()) {
            throw new NXCException(12, "Name and description for new DCI cannot be empty");
        }
        dcObject.setId(0L);
        dcObject.setNodeId(this.getObjectId());
        long dciId = this.getSession().modifyDataCollectionObject(dcObject);
        JSONObject result = new JSONObject();
        result.append("id", (Object)dciId);
        return result;
    }
}

