/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;

public class UserAgentNotification {
    private long id;
    private String message;
    private long[] objects;
    private String objectNames;
    private Date startTime;
    private Date endTime;
    private boolean recalled;
    private boolean onStartup;
    private Date creationTime;
    private long createdBy;

    public UserAgentNotification(NXCPMessage msg, long baseId, NXCSession session) {
        this.id = msg.getFieldAsInt32(baseId);
        this.message = msg.getFieldAsString(baseId + 1L);
        this.startTime = msg.getFieldAsDate(baseId + 2L);
        this.endTime = msg.getFieldAsDate(baseId + 3L);
        this.onStartup = msg.getFieldAsBoolean(baseId + 4L);
        this.objects = msg.getFieldAsUInt32Array(baseId + 5L);
        Arrays.sort(this.objects);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.objects.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(session.getObjectName(this.objects[i]));
            ++i;
        }
        this.objectNames = sb.toString();
        this.recalled = msg.getFieldAsBoolean(baseId + 6L);
        this.creationTime = msg.getFieldAsDate(baseId + 7L);
        this.createdBy = msg.getFieldAsInt64(baseId + 8L);
    }

    public long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public long[] getObjects() {
        return this.objects;
    }

    public String getObjectNames() {
        return this.objectNames;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isRecalled() {
        return this.recalled;
    }

    public boolean isStartupNotification() {
        return this.onStartup;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public long getCreatedBy() {
        return this.createdBy;
    }
}

