/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InputFieldType {
    TEXT(0),
    PASSWORD(1),
    NUMBER(2);

    private static final Logger logger;
    private static Map<Integer, InputFieldType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(InputFieldType.class);
        lookupTable = new HashMap<Integer, InputFieldType>();
        InputFieldType[] inputFieldTypeArray = InputFieldType.values();
        int n = inputFieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputFieldType element = inputFieldTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private InputFieldType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static InputFieldType getByValue(int value) {
        InputFieldType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return TEXT;
        }
        return element;
    }
}

