/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ActionExecutor
extends AbstractObjectToolExecutor
implements TextOutputListener {
    private IOConsoleOutputStream out;
    private String executionString;
    private long alarmId;
    private Map<String, String> inputValues;
    private List<String> maskedFields;
    protected long nodeId;

    public ActionExecutor(Composite parent, ViewPart viewPart, ObjectContext ctx, AbstractObjectToolExecutor.ActionSet actionSet, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        super(parent, viewPart, ctx, actionSet);
        this.alarmId = ctx.getAlarmId();
        this.nodeId = ctx.object.getObjectId();
        this.executionString = tool.getData();
        this.inputValues = inputValues;
        this.maskedFields = maskedFields;
    }

    @Override
    public void execute() {
        this.setRunning(true);
        final NXCSession session = ConsoleSharedData.getSession();
        this.out = this.console.newOutputStream();
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, session.getObjectName(ActionExecutor.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    session.executeActionWithExpansion(ActionExecutor.this.nodeId, ActionExecutor.this.alarmId, ActionExecutor.this.executionString, true, ActionExecutor.this.inputValues, ActionExecutor.this.maskedFields, (TextOutputListener)ActionExecutor.this, null);
                    IOConsoleOutputStream iOConsoleOutputStream = ActionExecutor.this.out;
                    Messages.get();
                    iOConsoleOutputStream.write(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    ActionExecutor.this.out.close();
                    ActionExecutor.this.out = null;
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ActionExecutor.this.setRunning(false);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
        super.dispose();
    }

    public void setStreamId(long streamId) {
    }

    public void onError() {
    }
}

