/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.text.Format;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisTick;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.axis.AxisTickLabels;
import org.swtchart.internal.axis.AxisTickMarks;

public class AxisTick
implements IAxisTick {
    private Chart chart;
    private Axis axis;
    private AxisTickLabels axisTickLabels;
    private AxisTickMarks axisTickMarks;
    private boolean isVisible;
    private int tickMarkStepHint;
    private int tickLabelAngle;
    private static final int DEFAULT_TICK_MARK_STEP_HINT = 64;

    protected AxisTick(Chart chart, Axis axis) {
        this.chart = chart;
        this.axis = axis;
        this.axisTickLabels = new AxisTickLabels(chart, axis);
        this.axisTickMarks = new AxisTickMarks(chart, axis);
        this.isVisible = true;
        this.tickLabelAngle = 0;
        this.tickMarkStepHint = 64;
    }

    public AxisTickMarks getAxisTickMarks() {
        return this.axisTickMarks;
    }

    public AxisTickLabels getAxisTickLabels() {
        return this.axisTickLabels;
    }

    @Override
    public void setForeground(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.axisTickMarks.setForeground(color);
        this.axisTickLabels.setForeground(color);
    }

    @Override
    public Color getForeground() {
        return this.axisTickMarks.getForeground();
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.axisTickLabels.setFont(font);
        this.chart.updateLayout();
    }

    @Override
    public Font getFont() {
        return this.axisTickLabels.getFont();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.chart.updateLayout();
    }

    @Override
    public int getTickMarkStepHint() {
        return this.tickMarkStepHint;
    }

    @Override
    public void setTickMarkStepHint(int tickMarkStepHint) {
        this.tickMarkStepHint = (double)tickMarkStepHint < 16.0 ? 64 : tickMarkStepHint;
        this.chart.updateLayout();
    }

    @Override
    public int getTickLabelAngle() {
        return this.tickLabelAngle;
    }

    @Override
    public void setTickLabelAngle(int angle) {
        if (angle < 0 || 90 < angle) {
            SWT.error((int)5);
        }
        if (this.tickLabelAngle != angle) {
            this.tickLabelAngle = angle;
            this.chart.updateLayout();
        }
    }

    @Override
    public void setFormat(Format format) {
        this.axisTickLabels.setFormat(format);
        this.chart.updateLayout();
    }

    @Override
    public Format getFormat() {
        return this.axisTickLabels.getFormat();
    }

    @Override
    public Rectangle getBounds() {
        Rectangle r1 = this.axisTickMarks.getBounds();
        Rectangle r2 = this.axisTickLabels.getBounds();
        IAxis.Position position = this.axis.getPosition();
        if (position == IAxis.Position.Primary && this.axis.isHorizontalAxis()) {
            return new Rectangle(r1.x, r1.y, r1.width, r1.height + r2.height);
        }
        if (position == IAxis.Position.Secondary && this.axis.isHorizontalAxis()) {
            return new Rectangle(r1.x, r2.y, r1.width, r1.height + r2.height);
        }
        if (position == IAxis.Position.Primary && !this.axis.isHorizontalAxis()) {
            return new Rectangle(r2.x, r1.y, r1.width + r2.width, r1.height);
        }
        if (position == IAxis.Position.Secondary && !this.axis.isHorizontalAxis()) {
            return new Rectangle(r1.x, r1.y, r1.width + r2.width, r1.height);
        }
        throw new IllegalStateException("unknown axis position");
    }

    @Override
    public double[] getTickLabelValues() {
        ArrayList<Double> list = this.axisTickLabels.getTickLabelValues();
        double[] values = new double[list.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = (Double)list.get(i);
            ++i;
        }
        return values;
    }

    protected void updateTick(int length) {
        if (length <= 0) {
            this.axisTickLabels.update(1);
        } else {
            this.axisTickLabels.update(length);
        }
    }

    protected void updateLayoutData() {
        this.axisTickLabels.updateLayoutData();
        this.axisTickMarks.updateLayoutData();
    }
}

