/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.mt.MappingTableDescriptor;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.CreateMappingTableDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.MappingTableListComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.MappingTableListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class MappingTables
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.MappingTables";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_FLAGS = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private NXCSession session;
    private SessionListener listener;
    private Map<Integer, MappingTableDescriptor> mappingTables = new HashMap<Integer, MappingTableDescriptor>();
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionNewTable;
    private Action actionEditTable;
    private Action actionDeleteTables;

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{80, 160, 80, 400};
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.MappingTables_ColID;
        Messages.get();
        stringArray[1] = Messages.MappingTables_ColName;
        Messages.get();
        stringArray[2] = Messages.MappingTables_ColFlags;
        Messages.get();
        stringArray[3] = Messages.MappingTables_ColDescription;
        String[] names = stringArray;
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MappingTableListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new MappingTableListComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MappingTables.this.editTable();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MappingTables.this.viewer.getSelection();
                MappingTables.this.actionEditTable.setEnabled(selection.size() == 1);
                MappingTables.this.actionDeleteTables.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"MappingTablesList");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)MappingTables.this.viewer, (IDialogSettings)settings, (String)"MappingTablesList");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = ConsoleSharedData.getSession();
        this.refresh(0);
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1019) {
                    final Integer id = (int)n.getSubCode();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MappingTables.this.refresh(id);
                        }
                    });
                } else if (n.getCode() == 1020) {
                    final Integer id = (int)n.getSubCode();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MappingTables.this.mappingTables.remove(id);
                            MappingTables.this.viewer.setInput((Object)MappingTables.this.mappingTables.values().toArray());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                MappingTables.this.refresh(0);
            }
        };
        Messages.get();
        this.actionNewTable = new Action(Messages.MappingTables_NewTable, SharedIcons.ADD_OBJECT){

            public void run() {
                MappingTables.this.createNewTable();
            }
        };
        Messages.get();
        this.actionEditTable = new Action(Messages.MappingTables_Edit, SharedIcons.EDIT){

            public void run() {
                MappingTables.this.editTable();
            }
        };
        this.actionEditTable.setEnabled(false);
        Messages.get();
        this.actionDeleteTables = new Action(Messages.MappingTables_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                MappingTables.this.deleteTables();
            }
        };
        this.actionDeleteTables.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewTable);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewTable);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MappingTables.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewTable);
        mgr.add((IAction)this.actionEditTable);
        mgr.add((IAction)this.actionDeleteTables);
    }

    private void refresh(final int tableId) {
        Messages.get();
        new ConsoleJob(Messages.MappingTables_ReloadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List tables = MappingTables.this.session.listMappingTables();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (tableId > 0) {
                            for (MappingTableDescriptor d : tables) {
                                if (d.getId() != tableId) continue;
                                MappingTableDescriptor od = (MappingTableDescriptor)MappingTables.this.mappingTables.get(tableId);
                                if (d.equals((Object)od)) break;
                                MappingTables.this.mappingTables.put(d.getId(), d);
                                break;
                            }
                        } else {
                            MappingTables.this.mappingTables.clear();
                            for (MappingTableDescriptor d : tables) {
                                MappingTables.this.mappingTables.put(d.getId(), d);
                            }
                        }
                        MappingTables.this.viewer.setInput((Object)MappingTables.this.mappingTables.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MappingTables_ReloadJobError;
            }
        }.start();
    }

    private void createNewTable() {
        final CreateMappingTableDialog dlg = new CreateMappingTableDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.MappingTables_CreateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Integer assignedId = MappingTables.this.session.createMappingTable(dlg.getName(), dlg.getDescription(), 0);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MappingTableDescriptor d = (MappingTableDescriptor)MappingTables.this.mappingTables.get(assignedId);
                        if (d == null) {
                            d = new MappingTableDescriptor(assignedId.intValue(), dlg.getName(), dlg.getDescription(), 0);
                            MappingTables.this.mappingTables.put(assignedId, d);
                        }
                        MappingTables.this.viewer.setInput((Object)MappingTables.this.mappingTables.values().toArray());
                        MappingTables.this.viewer.setSelection((ISelection)new StructuredSelection((Object)d));
                        MappingTables.this.editTable();
                    }
                });
            }

            protected String getErrorMessage() {
                return null;
            }
        }.start();
    }

    private void editTable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        MappingTableDescriptor d = (MappingTableDescriptor)selection.getFirstElement();
        try {
            this.getSite().getPage().showView("org.netxms.ui.eclipse.serverconfig.views.MappingTableEditor", Integer.toString(d.getId()), 1);
        }
        catch (PartInitException e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.MappingTables_Error, (String)String.format(Messages.MappingTables_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void deleteTables() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.MappingTables_DeleteConfirmation, (String)Messages.MappingTables_DeleteConfirmationText)) {
            return;
        }
        final ArrayList<Integer> tables = new ArrayList<Integer>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof MappingTableDescriptor)) continue;
            tables.add(((MappingTableDescriptor)o).getId());
        }
        Messages.get();
        new ConsoleJob(Messages.MappingTables_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Integer id : tables) {
                    MappingTables.this.session.deleteMappingTable(id.intValue());
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (Integer id : tables) {
                            MappingTables.this.mappingTables.remove(id);
                        }
                        MappingTables.this.viewer.setInput((Object)MappingTables.this.mappingTables.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MappingTables_DeleteJobError;
            }
        }.start();
    }
}

