/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.MutableObjectCategory;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ObjectCategoryEditDialog
extends Dialog {
    private MutableObjectCategory category;
    private LabeledText name;
    private ImageSelector icon;
    private ImageSelector mapImage;

    public ObjectCategoryEditDialog(Shell parentShell, MutableObjectCategory category) {
        super(parentShell);
        this.category = category;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.category != null ? "Edit Object Category" : "Create Object Category");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.name.setLayoutData((Object)gd);
        this.icon = new ImageSelector(dialogArea, 0);
        this.icon.setLabel("Icon");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.icon.setLayoutData((Object)gd);
        this.mapImage = new ImageSelector(dialogArea, 0);
        this.mapImage.setLabel("Map image");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.mapImage.setLayoutData((Object)gd);
        if (this.category != null) {
            this.name.setText(this.category.getName());
            this.icon.setImageGuid(this.category.getIcon(), false);
            this.mapImage.setImageGuid(this.category.getMapImage(), false);
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.name.getText().trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Category name cannot be empty!");
            return;
        }
        if (this.category == null) {
            this.category = new MutableObjectCategory(this.name.getText().trim(), this.icon.getImageGuid(), this.mapImage.getImageGuid());
        } else {
            this.category.setName(this.name.getText().trim());
            this.category.setIcon(this.icon.getImageGuid());
            this.category.setMapImage(this.mapImage.getImageGuid());
        }
        super.okPressed();
    }

    public MutableObjectCategory getCategory() {
        return this.category;
    }
}

