/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.widgets;

import java.util.UUID;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.NXCommon;
import org.netxms.client.LibraryImage;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ImageSelector
extends AbstractSelector
implements ImageUpdateListener {
    private UUID imageGuid = null;

    public ImageSelector(Composite parent, int style) {
        super(parent, style, 8);
        ImageProvider.getInstance().addUpdateListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageProvider.getInstance().removeUpdateListener(ImageSelector.this);
            }
        });
    }

    protected void selectionButtonHandler() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            LibraryImage image = dlg.getImage();
            if (image != null) {
                this.setText(image.getName());
                this.setImage(ImageProvider.getInstance().getImage(image.getGuid()));
                this.imageGuid = dlg.getImageGuid();
            } else {
                Messages.get();
                this.setText(Messages.ImageSelector_Default);
                this.setImage(null);
                this.imageGuid = null;
            }
            this.getParent().layout();
        }
    }

    protected void clearButtonHandler() {
        Messages.get();
        this.setText(Messages.ImageSelector_Default);
        this.setImage(null);
        this.imageGuid = null;
        this.getParent().layout();
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.ImageSelector_SelectImage;
    }

    public UUID getImageGuid() {
        return this.imageGuid;
    }

    public void setImageGuid(UUID imageGuid, boolean redoLayout) {
        this.imageGuid = imageGuid;
        if (imageGuid == null || imageGuid.equals(NXCommon.EMPTY_GUID)) {
            Messages.get();
            this.setText(Messages.ImageSelector_Default);
            this.setImage(null);
        } else {
            LibraryImage image = ImageProvider.getInstance().getLibraryImageObject(imageGuid);
            if (image != null) {
                this.setText(image.getName());
                this.setImage(ImageProvider.getInstance().getImage(imageGuid));
            } else {
                this.setText("<?>" + imageGuid.toString());
                this.setImage(null);
            }
        }
        if (redoLayout) {
            this.getParent().layout();
        }
    }

    @Override
    public void imageUpdated(UUID guid) {
        if (guid.equals(this.imageGuid)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageSelector.this.setImage(ImageProvider.getInstance().getImage(ImageSelector.this.imageGuid));
                    ImageSelector.this.getParent().layout();
                }
            });
        }
    }
}

