/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actionmanager.Activator;
import org.netxms.ui.eclipse.actionmanager.Messages;
import org.netxms.ui.eclipse.actionmanager.dialogs.EditActionDlg;
import org.netxms.ui.eclipse.actionmanager.views.helpers.ActionComparator;
import org.netxms.ui.eclipse.actionmanager.views.helpers.ActionLabelProvider;
import org.netxms.ui.eclipse.actionmanager.views.helpers.ActionManagerFilter;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ActionManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.actionmanager.views.ActionManager";
    private static final String TABLE_CONFIG_PREFIX = "ActionList";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_RCPT = 2;
    public static final int COLUMN_SUBJ = 3;
    public static final int COLUMN_DATA = 4;
    public static final int COLUMN_CHANNEL = 5;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Map<Long, ServerAction> actions = new HashMap<Long, ServerAction>();
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionShowFilter;
    private ActionManagerFilter filter;
    private FilterText filterText;
    private IDialogSettings settings;
    private Composite content;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionManager.this.onFilterModify();
            }
        });
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.ActionManager_ColumnName;
        Messages.get();
        stringArray[1] = Messages.ActionManager_ColumnType;
        Messages.get();
        stringArray[2] = Messages.ActionManager_ColumnRcpt;
        Messages.get();
        stringArray[3] = Messages.ActionManager_ColumnSubj;
        Messages.get();
        stringArray[4] = Messages.ActionManager_ColumnData;
        stringArray[5] = "Channel name";
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 90, 100, 120, 200, 100};
        this.viewer = new SortableTableViewer(this.content, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ActionLabelProvider labelProvider = new ActionLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ActionComparator());
        this.filter = new ActionManagerFilter(labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ActionManager.this.actionEdit.setEnabled(selection.size() == 1);
                    ActionManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionManager.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ActionManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ActionManager.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ActionManager.this.enableFilter(false);
                ActionManager.this.actionShowFilter.setChecked(false);
            }
        });
        if (this.actionShowFilter.isChecked()) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.session.addListener((SessionListener)this);
        this.refreshActionList();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void refreshActionList() {
        Messages.get();
        new ConsoleJob(Messages.ActionManager_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ActionManager_LoadJobError;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List actions = ActionManager.this.session.getActions();
                Map map = ActionManager.this.actions;
                synchronized (map) {
                    ActionManager.this.actions.clear();
                    for (ServerAction a : actions) {
                        ActionManager.this.actions.put(a.getId(), a);
                    }
                }
                ActionManager.this.updateActionsList();
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ActionManager.this.refreshActionList();
            }
        };
        this.actionNew = new Action(){

            public void run() {
                ActionManager.this.createAction();
            }
        };
        Messages.get();
        this.actionNew.setText(Messages.ActionManager_ActionNew);
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new Action(){

            public void run() {
                ActionManager.this.editAction();
            }
        };
        Messages.get();
        this.actionEdit.setText(Messages.ActionManager_ActionProperties);
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionDelete = new Action(){

            public void run() {
                ActionManager.this.deleteActions();
            }
        };
        Messages.get();
        this.actionDelete.setText(Messages.ActionManager_ActionDelete);
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                ActionManager.this.enableFilter(ActionManager.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("ActionManager.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ActionManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    private void createAction() {
        final ServerAction action = new ServerAction(0L);
        EditActionDlg dlg = new EditActionDlg(this.getSite().getShell(), action, true);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ActionManager_CreateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager"){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ActionManager_CreateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long id = ActionManager.this.session.createAction(action.getName());
                    action.setId(id);
                    ActionManager.this.session.modifyAction(action);
                }
            }.start();
        }
    }

    private void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ServerAction action = (ServerAction)selection.getFirstElement();
        EditActionDlg dlg = new EditActionDlg(this.getSite().getShell(), action, false);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ActionManager_UpdateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager"){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ActionManager_UpdateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ActionManager.this.session.modifyAction(action);
                }
            }.start();
        }
    }

    private void deleteActions() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ActionManager_Confirmation, (String)Messages.ActionManager_ConfirmDelete)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ActionManager_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ActionManager_DeleteJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ActionManager.this.session.deleteAction(((ServerAction)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    private void updateActionsList() {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ActionManager.this.actions;
                synchronized (map) {
                    ActionManager.this.viewer.setInput((Object)ActionManager.this.actions.values().toArray());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1006: 
            case 1007: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                }
                this.updateActionsList();
                break;
            }
            case 1008: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.remove(n.getSubCode());
                }
                this.updateActionsList();
            }
        }
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        this.settings.put("DataCollectionEditor.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = this.settings.get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }
}

