/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ForceReinstallPolicy
implements IObjectActionDelegate {
    private Shell shell;
    private Set<Template> currentSelection = new HashSet<Template>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        final NXCSession session = ConsoleSharedData.getSession();
        for (final Template template : this.currentSelection) {
            new ConsoleJob(String.format("Force policy installation", template.getObjectName()), null, "org.netxms.ui.eclipse.datacollection", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.forcePolicyInstallation(template.getObjectId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)ForceReinstallPolicy.this.shell, (String)"Force policy installation", (String)String.format("Policies for %s template were successfully installed", template.getObjectName()));
                        }
                    });
                }

                protected String getErrorMessage() {
                    return String.format("Unable force install policy from %s template", template.getObjectName());
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (o instanceof Template) {
                    this.currentSelection.add((Template)o);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        } else {
            action.setEnabled(false);
        }
    }
}

