/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs.pages;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.HeaderEditDialog;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class WebServiceHeaders
extends PreferencePage {
    private WebServiceDefinition definition;
    private Map<String, String> headers;
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;

    public WebServiceHeaders(WebServiceDefinition definition) {
        super("Headers");
        this.noDefaultAndApplyButton();
        this.definition = definition;
        this.headers = new HashMap<String, String>(definition.getHeaders());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67584);
        this.setupViewer();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 450;
        this.viewer.getTable().setLayoutData((Object)gd);
        Composite buttonArea = new Composite(dialogArea, 0);
        RowLayout btnLayout = new RowLayout();
        btnLayout.type = 512;
        btnLayout.marginBottom = 0;
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.marginTop = 0;
        btnLayout.fill = true;
        btnLayout.spacing = 4;
        buttonArea.setLayout((Layout)btnLayout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonArea, 8);
        this.buttonAdd.setText("&Add...");
        this.buttonAdd.setLayoutData((Object)new RowData(90, -1));
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceHeaders.this.addHeader();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonEdit = new Button(buttonArea, 8);
        this.buttonEdit.setText("&Edit...");
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceHeaders.this.editHeader();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonEdit.setEnabled(false);
        this.buttonDelete = new Button(buttonArea, 8);
        this.buttonDelete.setText("&Delete");
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                WebServiceHeaders.this.deleteHeaders();
            }
        });
        this.buttonDelete.setEnabled(false);
        return dialogArea;
    }

    private void addHeader() {
        HeaderEditDialog dlg = new HeaderEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.headers.put(dlg.getName(), dlg.getValue());
            this.viewer.refresh();
        }
    }

    private void editHeader() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        HeaderEditDialog dlg = new HeaderEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.headers.put(dlg.getName(), dlg.getValue());
            this.viewer.refresh();
        }
    }

    private void deleteHeaders() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.headers.remove(((Map.Entry)o).getKey());
        }
        this.viewer.refresh();
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WebServiceHeaders");
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            this.saveSettings();
        }
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isControlCreated()) {
            this.definition.getHeaders().clear();
            for (Map.Entry<String, String> e : this.headers.entrySet()) {
                this.definition.setHeader(e.getKey(), e.getValue());
            }
            this.saveSettings();
        }
        return super.performOk();
    }

    private void setupViewer() {
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText("Name");
        tc.setWidth(200);
        tc = new TableColumn(table, 16384);
        tc.setText("Value");
        tc.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Set)inputElement).toArray();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new HeaderLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String v1 = (String)((Map.Entry)e1).getKey();
                String v2 = (String)((Map.Entry)e2).getKey();
                return v1.compareToIgnoreCase(v2);
            }
        });
        this.viewer.setInput(this.headers.entrySet());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebServiceHeaders.this.editHeader();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = WebServiceHeaders.this.viewer.getStructuredSelection();
                WebServiceHeaders.this.buttonEdit.setEnabled(selection.size() == 1);
                WebServiceHeaders.this.buttonDelete.setEnabled(!selection.isEmpty());
            }
        });
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WebServiceHeaders");
    }

    private class HeaderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HeaderLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? (String)((Map.Entry)element).getKey() : (String)((Map.Entry)element).getValue();
        }
    }
}

