/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.api.GraphTemplateCache;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class TemplateGraphDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public TemplateGraphDynamicMenu() {
    }

    public TemplateGraphDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) {
            return;
        }
        AbstractNode firstNode = null;
        for (Object o : ((IStructuredSelection)selection).toList()) {
            if (!(o instanceof AbstractNode)) continue;
            firstNode = (AbstractNode)o;
            break;
        }
        if (firstNode == null) {
            return;
        }
        final AbstractNode node = firstNode;
        GraphSettings[] settings = GraphTemplateCache.getInstance().getGraphTemplates();
        Menu graphMenu = new Menu(menu);
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < settings.length) {
            if (settings[i].isApplicableForNode(node)) {
                String[] path = settings[i].getName().split("\\-\\>");
                Menu rootMenu = graphMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = String.valueOf(rootMenu.hashCode()) + "@" + path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)settings[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        final NXCSession session = ConsoleSharedData.getSession();
                        final GraphSettings gs = (GraphSettings)item.getData();
                        ConsoleJob job = new ConsoleJob(String.format("Display graph from template for node %s", node.getObjectName()), null, "org.netxms.ui.eclipse.perfview", null){

                            protected String getErrorMessage() {
                                return String.format("Cannot craete graph from template for node %s", node.getObjectName());
                            }

                            protected void runInternal(IProgressMonitor monitor) throws Exception {
                                DciValue[] data = session.getLastValues(node.getObjectId());
                                GraphTemplateCache.instantiate(node, gs, data, session, this.getDisplay());
                            }
                        };
                        job.setUser(false);
                        job.start();
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem graphMenuItem = new MenuItem(menu, 64, index);
            graphMenuItem.setText("Graphs");
            graphMenuItem.setMenu(graphMenu);
        } else {
            graphMenu.dispose();
        }
    }
}

